/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.FixType;
import io.fixprotocol.orchestra.model.FixValue;
import io.fixprotocol.orchestra.model.ModelException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class FixValueFactory {
    public static FixValue<?> copy(String name, FixValue<?> operand) throws ModelException {
        String valueClassname = operand.getValue().getClass().getName();
        FixType type = operand.getType();
        switch (valueClassname) {
            case "java.lang.Integer": {
                return new FixValue<Integer>(name, type, (Integer)operand.getValue());
            }
            case "java.lang.String": {
                return new FixValue<String>(name, type, (String)operand.getValue());
            }
            case "java.math.BigDecimal": {
                return new FixValue<BigDecimal>(name, type, (BigDecimal)operand.getValue());
            }
            case "java.lang.Boolean": {
                return new FixValue<Boolean>(name, type, (Boolean)operand.getValue());
            }
            case "java.lang.Character": {
                return new FixValue<Character>(name, type, (Character)operand.getValue());
            }
            case "[B": {
                return new FixValue<byte[]>(name, type, (byte[])operand.getValue());
            }
            case "java.time.Instant": {
                return new FixValue<Instant>(name, type, (Instant)operand.getValue());
            }
            case "java.time.LocalDate": {
                return new FixValue<LocalDate>(name, type, (LocalDate)operand.getValue());
            }
            case "java.time.LocalTime": {
                return new FixValue<LocalTime>(name, type, (LocalTime)operand.getValue());
            }
            case "java.time.ZonedDateTime": {
                return new FixValue<ZonedDateTime>(name, type, (ZonedDateTime)operand.getValue());
            }
        }
        throw new ModelException("Unable to copy type " + valueClassname);
    }

    public static FixValue create(String name, FixType type, Class<?> valueClass) throws ModelException {
        Objects.requireNonNull(type, "FIX type missing");
        Objects.requireNonNull(valueClass, "Value class missing");
        switch (valueClass.getName()) {
            case "java.lang.Integer": {
                return new FixValue(name, type);
            }
            case "java.lang.String": {
                return new FixValue(name, type);
            }
            case "java.math.BigDecimal": {
                return new FixValue(name, type);
            }
            case "java.lang.Boolean": {
                return new FixValue(name, type);
            }
            case "java.lang.Character": {
                return new FixValue(name, type);
            }
            case "[B": {
                return new FixValue(name, type);
            }
            case "java.time.Instant": {
                return new FixValue(name, type);
            }
            case "java.time.LocalDate": {
                return new FixValue(name, type);
            }
            case "java.time.LocalTime": {
                return new FixValue(name, type);
            }
            case "java.time.ZonedDateTime": {
                return new FixValue(name, type);
            }
        }
        throw new ModelException("Unable to create type " + valueClass.getName());
    }
}

