/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.AbstractScope;
import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.FixValue;
import io.fixprotocol.orchestra.model.ModelException;
import io.fixprotocol.orchestra.model.PathStep;
import io.fixprotocol.orchestra.model.Scope;
import java.util.ArrayDeque;

public class LocalScope
extends AbstractScope {
    private final String name;
    private Scope parent;
    private final ArrayDeque<Scope> stack = new ArrayDeque();

    public LocalScope(String name) {
        this.name = name;
    }

    @Override
    public FixValue<?> assign(PathStep pathStep, FixValue<?> value) throws ModelException {
        Scope local = this.stack.peekFirst();
        if (local != null) {
            return local.assign(pathStep, value);
        }
        throw new ModelException("No local scope to assign value");
    }

    @Override
    public void close() throws Exception {
        if (this.parent != null) {
            this.parent.remove(new PathStep(this.name));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Scope nest(PathStep pathStep, Scope nested) {
        this.stack.addFirst(nested);
        nested.setParent(this);
        this.traceNest(pathStep, nested);
        return nested;
    }

    @Override
    public FixNode remove(PathStep pathStep) {
        Scope removed = this.stack.pollFirst();
        this.traceRemove(pathStep, removed);
        return removed;
    }

    @Override
    public FixNode resolve(PathStep pathStep) {
        Scope local = this.stack.peekFirst();
        if (local != null) {
            return local.resolve(pathStep);
        }
        return null;
    }

    @Override
    public void setParent(Scope parent) {
        this.parent = parent;
    }

    @Override
    protected void traceNest(PathStep pathStep, Scope nested) {
        if (this.isTrace()) {
            traceHandler.accept(String.format("Path %s scope %s nested under scope %s", pathStep.getName(), nested.getName(), this.getName()));
        }
    }

    @Override
    protected void traceRemove(PathStep pathStep, FixNode removed) {
        if (this.isTrace()) {
            Scope current = this.stack.peekFirst();
            traceHandler.accept(String.format("Scope %s removed from local scope; current scope is %s", pathStep.getName(), current != null ? current.getName() : "none"));
        }
    }
}

