/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.FixValue;
import io.fixprotocol.orchestra.model.LocalScope;
import io.fixprotocol.orchestra.model.ModelException;
import io.fixprotocol.orchestra.model.PathStep;
import io.fixprotocol.orchestra.model.Scope;
import io.fixprotocol.orchestra.model.TreeSymbolTable;

public class SymbolResolver
extends TreeSymbolTable {
    public static final PathStep VARIABLE_ROOT = new PathStep("$");
    public static final PathStep CODE_SET_ROOT = new PathStep("^");
    public static final PathStep LOCAL_ROOT = new PathStep("this.");

    public SymbolResolver() {
        super("global");
        this.nest(VARIABLE_ROOT, new TreeSymbolTable("variables"));
        this.nest(LOCAL_ROOT, new LocalScope("local"));
    }

    @Override
    public FixValue<?> assign(PathStep pathStep, FixValue<?> value) throws ModelException {
        String pathName = pathStep.getName();
        if (pathName.startsWith("$")) {
            Scope variables = (Scope)super.resolve(VARIABLE_ROOT);
            PathStep vPathStep = new PathStep(pathName.substring(1));
            vPathStep.setIndex(pathStep.getIndex());
            vPathStep.setPredicate(pathStep.getPredicate());
            return variables.assign(vPathStep, value);
        }
        if (pathName.startsWith("this.")) {
            Scope variables = (Scope)super.resolve(LOCAL_ROOT);
            PathStep vPathStep = new PathStep(pathName.substring(5));
            vPathStep.setIndex(pathStep.getIndex());
            vPathStep.setPredicate(pathStep.getPredicate());
            return variables.assign(vPathStep, value);
        }
        return super.assign(pathStep, value);
    }

    @Override
    public FixNode resolve(PathStep pathStep) {
        Scope variables;
        FixNode node = null;
        String pathName = pathStep.getName();
        if (pathName.length() > 1 && pathName.startsWith(VARIABLE_ROOT.getName())) {
            variables = (Scope)super.resolve(VARIABLE_ROOT);
            PathStep vPathStep = new PathStep(pathName.substring(1));
            vPathStep.setIndex(pathStep.getIndex());
            vPathStep.setPredicate(pathStep.getPredicate());
            node = variables.resolve(vPathStep);
        } else if (pathName.length() > 5 && pathName.startsWith(LOCAL_ROOT.getName())) {
            variables = (Scope)super.resolve(LOCAL_ROOT);
            PathStep vPathStep = new PathStep(pathName.substring(5));
            vPathStep.setIndex(pathStep.getIndex());
            vPathStep.setPredicate(pathStep.getPredicate());
            node = variables.resolve(vPathStep);
        } else {
            node = super.resolve(pathStep);
        }
        if (node == null) {
            Scope local = (Scope)super.resolve(LOCAL_ROOT);
            node = local.resolve(pathStep);
        }
        return node;
    }
}

