/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.AbstractScope;
import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.FixValue;
import io.fixprotocol.orchestra.model.ModelException;
import io.fixprotocol.orchestra.model.PathStep;
import io.fixprotocol.orchestra.model.Scope;
import java.util.HashMap;
import java.util.Map;

public class TreeSymbolTable
extends AbstractScope {
    private final String name;
    private Scope parent;
    private final Map<String, FixNode> symbols = new HashMap<String, FixNode>();

    public TreeSymbolTable(String name) {
        this.name = name;
    }

    @Override
    public FixValue<?> assign(PathStep pathStep, FixValue<?> value) throws ModelException {
        FixNode node = this.symbols.get(pathStep.getName());
        if (node instanceof FixValue) {
            FixValue val = (FixValue)node;
            val.assign(value);
            return val;
        }
        if (node == null) {
            this.symbols.put(pathStep.getName(), value);
            return value;
        }
        throw new ModelException("FixNode already exists named " + pathStep.getName());
    }

    @Override
    public void close() throws Exception {
        if (this.parent != null) {
            this.parent.remove(new PathStep(this.name));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Scope nest(PathStep pathStep, Scope nested) {
        this.symbols.put(pathStep.getName(), nested);
        this.traceNest(pathStep, nested);
        return nested;
    }

    @Override
    public FixNode remove(PathStep pathStep) {
        FixNode removed = this.symbols.remove(pathStep.getName());
        this.traceRemove(pathStep, removed);
        return removed;
    }

    @Override
    public FixNode resolve(PathStep pathStep) {
        return this.symbols.get(pathStep.getName());
    }

    @Override
    public void setParent(Scope parent) {
        this.parent = parent;
    }

    public String toString() {
        return "TreeSymbolTable [" + (this.name != null ? "name=" + this.name + ", " : "") + (this.parent != null ? "parent=" + this.parent + ", " : "") + "symbols=" + this.symbols + "]";
    }
}

