/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.event;

import io.fixprotocol.orchestra.event.Event;
import io.fixprotocol.orchestra.event.EventListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class TeeEventListener
implements EventListener {
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();

    public void addEventListener(EventListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "EventListener missing"));
    }

    @Override
    public void close() throws Exception {
        for (EventListener listener : this.listeners) {
            listener.close();
        }
    }

    @Override
    public void event(Event event) {
        for (EventListener listener : this.listeners) {
            listener.event(event);
        }
    }

    public List<EventListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }
}

