/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.event.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.fixprotocol.orchestra.event.Event;
import io.fixprotocol.orchestra.event.EventListener;
import java.io.IOException;
import java.io.OutputStream;

public class JSONEventListener
implements EventListener {
    private JsonGenerator generator = null;

    public JSONEventListener() {
    }

    public JSONEventListener(OutputStream outputStream) throws IOException {
        this.setOutputStream(outputStream);
    }

    @Override
    public void close() throws Exception {
        this.generator.close();
    }

    @Override
    public void event(Event event) {
        try {
            if (this.generator == null) {
                throw new IllegalStateException("JSONEventListener not ready; call setOutputStream()");
            }
            this.generator.writeStartObject();
            this.generator.writeObjectField("severity", (Object)event.getSeverity().name());
            this.generator.writeObjectField("message", (Object)event.getMessage());
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        JsonFactory factory = new JsonFactory();
        this.generator = factory.createGenerator(outputStream);
        this.generator.writeStartObject();
        this.generator.writeArrayFieldStart("events");
    }

    @Override
    public void setResource(Object resource) throws Exception {
        if (!(resource instanceof OutputStream)) {
            throw new IllegalArgumentException("No implementation for resource class");
        }
        this.setOutputStream((OutputStream)resource);
    }
}

