/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.event.log4j2;

import io.fixprotocol.orchestra.event.Event;
import io.fixprotocol.orchestra.event.EventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4jEventLogger
implements EventListener {
    private volatile boolean isOpen = true;
    private Logger logger;

    public Log4jEventLogger() {
        this.logger = LogManager.getLogger(Log4jEventLogger.class);
    }

    public Log4jEventLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void close() throws Exception {
        this.isOpen = false;
    }

    @Override
    public void event(Event event) {
        if (this.isOpen) {
            switch (event.getSeverity()) {
                case INFO: {
                    this.logger.info(event.getMessage());
                    break;
                }
                case ERROR: {
                    this.logger.error(event.getMessage());
                    break;
                }
                case FATAL: {
                    this.logger.fatal(event.getMessage());
                    break;
                }
                case WARN: {
                    this.logger.warn(event.getMessage());
                }
            }
        }
    }

    @Override
    public void setResource(Object resource) {
        if (!(resource instanceof Logger)) {
            throw new IllegalArgumentException("No implementation for resource class");
        }
        this.logger = (Logger)resource;
    }
}

