/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.docgen;

import io.fixprotocol._2020.orchestra.repository.ActorType;
import io.fixprotocol._2020.orchestra.repository.Actors;
import io.fixprotocol._2020.orchestra.repository.CatComponentTypeT;
import io.fixprotocol._2020.orchestra.repository.Categories;
import io.fixprotocol._2020.orchestra.repository.CategoryType;
import io.fixprotocol._2020.orchestra.repository.CodeSetType;
import io.fixprotocol._2020.orchestra.repository.CodeType;
import io.fixprotocol._2020.orchestra.repository.ComponentRefType;
import io.fixprotocol._2020.orchestra.repository.ComponentType;
import io.fixprotocol._2020.orchestra.repository.Datatype;
import io.fixprotocol._2020.orchestra.repository.FieldRefType;
import io.fixprotocol._2020.orchestra.repository.FieldRuleType;
import io.fixprotocol._2020.orchestra.repository.FieldType;
import io.fixprotocol._2020.orchestra.repository.FlowType;
import io.fixprotocol._2020.orchestra.repository.GroupRefType;
import io.fixprotocol._2020.orchestra.repository.GroupType;
import io.fixprotocol._2020.orchestra.repository.MessageRefType;
import io.fixprotocol._2020.orchestra.repository.MessageType;
import io.fixprotocol._2020.orchestra.repository.PresenceT;
import io.fixprotocol._2020.orchestra.repository.Repository;
import io.fixprotocol._2020.orchestra.repository.ResponseType;
import io.fixprotocol._2020.orchestra.repository.StateMachineType;
import io.fixprotocol._2020.orchestra.repository.SupportType;
import io.fixprotocol.orchestra.docgen.FileManager;
import io.fixprotocol.orchestra.docgen.ImgGenerator;
import io.fixprotocol.orchestra.docgen.PathManager;
import io.fixprotocol.orchestra.docgen.ZipFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.purl.dc.elements._1.SimpleLiteral;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.misc.STMessage;

public class DocGenerator {
    private static final Map<SupportType, String> supportedMap = new HashMap<SupportType, String>();
    private final PrintStream errorStream;
    private final ImgGenerator imgGenerator = new ImgGenerator();
    private final InputStream inputStream;
    private final String outputRootDir;
    private PathManager pathManager;
    private Repository repository;
    private final STGroup stGroup;
    private final STErrorListener templateErrorListener = new STErrorListener(){

        public void compileTimeError(STMessage msg) {
            DocGenerator.this.errorStream.println(msg.toString());
        }

        public void internalError(STMessage msg) {
            DocGenerator.this.errorStream.println(msg.toString());
        }

        public void IOError(STMessage msg) {
            DocGenerator.this.errorStream.println(msg.toString());
        }

        public void runTimeError(STMessage msg) {
            DocGenerator.this.errorStream.println(msg.toString());
        }
    };
    private final ValidationEventHandler unmarshallerErrorHandler = new ValidationEventHandler(){

        public boolean handleEvent(ValidationEvent event) {
            DocGenerator.this.errorStream.print(String.format("%s line %d col %d %s", this.severityToString(event.getSeverity()), event.getLocator().getLineNumber(), event.getLocator().getColumnNumber(), event.getMessage()));
            return event.getSeverity() == 0;
        }

        private String severityToString(int severity) {
            switch (severity) {
                case 0: {
                    return "WARN ";
                }
                case 1: {
                    return "ERROR";
                }
            }
            return "FATAL";
        }
    };

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java io.fixprotocol.orchestra.docgen.DocGenerator <input-file> [output-uri] [error-path]");
        } else {
            PrintStream errorStream;
            FileInputStream inputStream = new FileInputStream(args[0]);
            String outputRootDir = args.length > 1 ? args[1] : "./doc";
            if (args.length > 2) {
                File errFile = new File(args[2]);
                Files.createDirectories(errFile.toPath().getParent(), new FileAttribute[0]);
                errorStream = new PrintStream(errFile);
            } else {
                errorStream = System.err;
            }
            DocGenerator gen = new DocGenerator(inputStream, outputRootDir, errorStream);
            gen.generate();
        }
    }

    public DocGenerator(InputStream inputStream, String outputRootDir, PrintStream errorStream) {
        this.outputRootDir = outputRootDir;
        this.stGroup = new STGroupFile("templates/docgen.stg", '$', '$');
        this.inputStream = inputStream;
        this.errorStream = errorStream;
    }

    public void generate() throws Exception {
        this.repository = this.unmarshal(this.inputStream);
        this.pathManager = this.getPathManager(this.outputRootDir);
        Path baseOutputPath = this.pathManager.makeRootPath(this.outputRootDir);
        this.createCss(baseOutputPath);
        this.generateMain(baseOutputPath, this.getTitle());
        this.generateMetadata(baseOutputPath, this.repository, this.repository.getMetadata().getAny());
        Path datatypesOutputPath = this.pathManager.makeDirectory(baseOutputPath.resolve("datatypes"));
        this.generateDatatypeList(datatypesOutputPath, this.repository.getDatatypes().getDatatype());
        this.repository.getDatatypes().getDatatype().forEach(d -> {
            try {
                this.generateDatatype(datatypesOutputPath, (Datatype)d);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Path fieldsOutputPath = this.pathManager.makeDirectory(baseOutputPath.resolve("fields"));
        List<FieldType> sortedFieldList = this.repository.getFields().getField().stream().sorted(Comparator.comparing(FieldType::getName)).collect(Collectors.toList());
        this.generateFieldsList(fieldsOutputPath, sortedFieldList);
        this.repository.getFields().getField().forEach(f -> {
            try {
                this.generateFieldDetail(fieldsOutputPath, (FieldType)f);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List allCodeSets = this.repository.getCodeSets().getCodeSet();
        this.generateCodeSetList(datatypesOutputPath, allCodeSets.stream().sorted(Comparator.comparing(CodeSetType::getName)).collect(Collectors.toList()));
        this.repository.getCodeSets().getCodeSet().forEach(cs -> {
            try {
                this.generateCodeSetDetail(datatypesOutputPath, (CodeSetType)cs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Path messagesDocPath = this.pathManager.makeDirectory(baseOutputPath.resolve("messages"));
        Path messagesImgPath = this.pathManager.makeDirectory(messagesDocPath.resolve("img"));
        Optional<Categories> optCategories = Optional.ofNullable(this.repository.getCategories());
        List<CategoryType> sortedCategoryList = optCategories.orElse(new Categories()).getCategory().stream().filter(c -> c.getComponentType() == CatComponentTypeT.MESSAGE).sorted((o1, o2) -> {
            String sectionValue2;
            String sectionValue1 = o1.getSection() != null ? o1.getSection() : "";
            int retv = sectionValue1.compareTo(sectionValue2 = o2.getSection() != null ? o2.getSection() : "");
            if (retv == 0) {
                retv = o1.getName().compareTo(o2.getName());
            }
            return retv;
        }).collect(Collectors.toList());
        this.generateCategories(messagesDocPath, "Message Categories", sortedCategoryList);
        List<MessageType> sortedMessageList = this.repository.getMessages().getMessage().stream().sorted(Comparator.comparing(MessageType::getName).thenComparing(MessageType::getScenario)).collect(Collectors.toList());
        Optional<Actors> actors = Optional.ofNullable(this.repository.getActors());
        List<ActorType> actorList = actors.orElse(new Actors()).getActorOrFlow().stream().filter(af -> af instanceof ActorType).map(af -> (ActorType)af).collect(Collectors.toList());
        this.generateActorsList(messagesDocPath, actorList);
        actorList.forEach(a -> {
            try {
                this.generateActorDetail(messagesDocPath, messagesImgPath, (ActorType)a);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List<FlowType> flowList = actors.orElse(new Actors()).getActorOrFlow().stream().filter(af -> af instanceof FlowType).map(af -> (FlowType)af).collect(Collectors.toList());
        this.generateFlowsList(messagesDocPath, flowList);
        flowList.forEach(f -> {
            try {
                this.generateFlowDetail(messagesDocPath, (FlowType)f);
                this.generateMessageListByFlow(messagesDocPath, (FlowType)f, sortedMessageList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.generateAllMessageList(messagesDocPath, sortedMessageList);
        sortedCategoryList.forEach(c -> {
            try {
                this.generateMessageListByCategory(messagesDocPath, (CategoryType)c, sortedMessageList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List componentList = this.repository.getComponents().getComponent();
        List<ComponentType> sortedComponentList = componentList.stream().sorted(Comparator.comparing(ComponentType::getName).thenComparing(ComponentType::getScenario)).collect(Collectors.toList());
        this.generateAllComponentsList(messagesDocPath, sortedComponentList);
        componentList.forEach(c -> {
            try {
                this.generateComponentDetail(messagesDocPath, (ComponentType)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List groupList = this.repository.getGroups().getGroup();
        List<GroupType> sortedGroupList = groupList.stream().sorted(Comparator.comparing(GroupType::getName).thenComparing(GroupType::getScenario)).collect(Collectors.toList());
        this.generateAllGroupsList(messagesDocPath, sortedGroupList);
        groupList.forEach(c -> {
            try {
                this.generateGroupDetail(messagesDocPath, (GroupType)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.repository.getMessages().getMessage().forEach(m -> {
            try {
                this.generateMessageDetail(messagesDocPath, messagesImgPath, (MessageType)m);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.pathManager.close();
    }

    private void createCss(Path baseOutputPath) throws IOException {
        Path pathCss = baseOutputPath.resolve("orchestra.css");
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream("orchestra.css");){
            this.pathManager.copyStreamToPath(in, pathCss);
        }
    }

    private void generateActorDetail(Path messagesDocPath, Path messagesImgPath, ActorType actor) throws Exception {
        List stateMachines = actor.getFieldOrFieldRefOrComponent().stream().filter(o -> o instanceof StateMachineType).collect(Collectors.toList());
        Path path = messagesDocPath.resolve(String.format("%s.html", actor.getName()));
        try (STWriterWrapper writer = this.getWriter(path);){
            ST stActor = this.stGroup.getInstanceOf("actorStart");
            stActor.add("actor", (Object)actor);
            stActor.write((STWriter)writer, this.templateErrorListener);
            List members = actor.getFieldOrFieldRefOrComponent();
            this.generateMembers(members, (STWriter)writer);
            ST stActor2 = this.stGroup.getInstanceOf("actorPart2");
            stActor2.add("actor", (Object)actor);
            stActor2.write((STWriter)writer, this.templateErrorListener);
            for (Object stateMachine : stateMachines) {
                ST stStates = this.stGroup.getInstanceOf("stateMachine");
                stStates.add("states", stateMachine);
                stStates.write((STWriter)writer, this.templateErrorListener);
            }
        }
        for (Object stateMachine : stateMachines) {
            this.imgGenerator.generateUMLStateMachine(messagesImgPath, this.pathManager, (StateMachineType)stateMachine, this.templateErrorListener);
        }
    }

    private void generateActorsList(Path messagesDocPath, List<ActorType> actorList) throws Exception {
        ST st = this.stGroup.getInstanceOf("actors");
        st.add("actors", actorList);
        st.add("title", (Object)"All Actors");
        Path path = messagesDocPath.resolve("AllActors.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateAllComponentsList(Path messagesDocPath, List<ComponentType> componentList) throws Exception {
        ST st = this.stGroup.getInstanceOf("components");
        st.add("components", componentList);
        st.add("title", (Object)"All Components");
        Path path = messagesDocPath.resolve("AllComponents.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateAllGroupsList(Path messagesDocPath, List<GroupType> componentList) throws Exception {
        ST st = this.stGroup.getInstanceOf("groups");
        st.add("groups", componentList);
        st.add("title", (Object)"All Groups");
        Path path = messagesDocPath.resolve("AllGroups.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateAllMessageList(Path messagesDocPath, List<MessageType> messageList) throws Exception {
        ST st = this.stGroup.getInstanceOf("messages");
        st.add("messages", messageList);
        st.add("title", (Object)"All Messages");
        Path path = messagesDocPath.resolve("AllMessages.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateCategories(Path messagesDocPath, String title, List<CategoryType> categoriesList) throws Exception {
        ST st = this.stGroup.getInstanceOf("categories");
        st.add("title", (Object)title);
        st.add("categories", categoriesList);
        Path path = messagesDocPath.resolve("MessageCategories.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateCodeSetDetail(Path datatypesOutputPath, CodeSetType codeSet) throws Exception {
        Path path = datatypesOutputPath.resolve(String.format("%s-%s.html", codeSet.getName(), codeSet.getScenario()));
        try (STWriterWrapper writer = this.getWriter(path);){
            ST stCodesetStart = this.stGroup.getInstanceOf("codeSetStart");
            stCodesetStart.add("codeSet", (Object)codeSet);
            stCodesetStart.write((STWriter)writer, this.templateErrorListener);
            List codeList = codeSet.getCode();
            for (CodeType code : codeList) {
                ST stCode = this.stGroup.getInstanceOf("code");
                stCode.add("code", (Object)code);
                stCode.add("supported", (Object)supportedMap.get(code.getSupported()));
                stCode.write((STWriter)writer, this.templateErrorListener);
            }
            ST stCodesetEnd = this.stGroup.getInstanceOf("codeSetEnd");
            stCodesetEnd.add("codeSet", (Object)codeSet);
            stCodesetEnd.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateCodeSetList(Path datatypesOutputPath, List<CodeSetType> codeSetList) throws Exception {
        ST st = this.stGroup.getInstanceOf("codeSets");
        st.add("codeSets", codeSetList);
        st.add("title", (Object)"All Code Sets");
        Path path = datatypesOutputPath.resolve("AllCodeSets.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateComponentDetail(Path messagesDocPath, ComponentType component) throws Exception {
        ST stComponentStart = this.stGroup.getInstanceOf("componentStart");
        stComponentStart.add("component", (Object)component);
        ST stComponentEnd = this.stGroup.getInstanceOf("componentEnd");
        List members = component.getComponentRefOrGroupRefOrFieldRef();
        Path path = messagesDocPath.resolve(String.format("%s-%s.html", component.getName(), component.getScenario()));
        try (STWriterWrapper writer = this.getWriter(path);){
            stComponentStart.write((STWriter)writer, this.templateErrorListener);
            this.generateMembers(members, (STWriter)writer);
            stComponentEnd.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateDatatype(Path datatypesOutputPath, Datatype datatype) throws Exception {
        ST st = this.stGroup.getInstanceOf("datatype");
        st.add("datatype", (Object)datatype);
        Path path = datatypesOutputPath.resolve(String.format("%s.html", datatype.getName()));
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateDatatypeList(Path datatypesOutputPath, List<Datatype> datatypeList) throws Exception {
        ST st = this.stGroup.getInstanceOf("datatypes");
        st.add("datatypes", datatypeList);
        st.add("title", (Object)"All Datatypes");
        Path path = datatypesOutputPath.resolve("AllDatatypes.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateFieldDetail(Path fieldsOutputPath, FieldType field) throws Exception {
        ST st = this.stGroup.getInstanceOf("field");
        st.add("field", (Object)field);
        st.add("typeLink", (Object)this.getTypeLink(field.getType(), field.getScenario()));
        Path path = fieldsOutputPath.resolve(String.format("%s-%s.html", field.getName(), field.getScenario()));
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateFieldsList(Path fieldsOutputPath, List<FieldType> fieldList) throws Exception {
        ST st = this.stGroup.getInstanceOf("fields");
        st.add("fields", fieldList);
        st.add("title", (Object)"All Fields");
        Path path = fieldsOutputPath.resolve("AllFields.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateFlowDetail(Path messagesDocPath, FlowType flow) throws Exception {
        ST st = this.stGroup.getInstanceOf("flow");
        st.add("flow", (Object)flow);
        Path path = messagesDocPath.resolve(String.format("%s.html", flow.getName()));
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateFlowsList(Path messagesDocPath, List<FlowType> flowList) throws Exception {
        ST st = this.stGroup.getInstanceOf("flows");
        st.add("flows", flowList);
        st.add("title", (Object)"All Flows");
        Path path = messagesDocPath.resolve("AllFlows.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateGroupDetail(Path messagesDocPath, GroupType group) throws Exception {
        ST stGroupStart = this.stGroup.getInstanceOf("groupStart");
        stGroupStart.add("groupType", (Object)group);
        FieldType field = this.getField(group.getNumInGroup().getId().intValue());
        stGroupStart.add("fieldType", (Object)field);
        ST stComponentEnd = this.stGroup.getInstanceOf("componentEnd");
        List members = group.getComponentRefOrGroupRefOrFieldRef();
        Path path = messagesDocPath.resolve(String.format("%s-%s.html", group.getName(), group.getScenario()));
        try (STWriterWrapper writer = this.getWriter(path);){
            stGroupStart.write((STWriter)writer, this.templateErrorListener);
            this.generateMembers(members, (STWriter)writer);
            stComponentEnd.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateMain(Path baseOutputPath, String title) throws Exception {
        ST st = this.stGroup.getInstanceOf("main");
        st.add("title", (Object)title);
        Path path = baseOutputPath.resolve("index.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateMembers(List<Object> members, STWriter writer) {
        for (Object member : members) {
            ST stComponent;
            GroupType component;
            if (member instanceof FieldRefType) {
                FieldType field = this.getField(((FieldRefType)member).getId().intValue());
                ST stField = this.stGroup.getInstanceOf("fieldMember");
                stField.add("field", (Object)field);
                if (((FieldRefType)member).getSupported() == SupportType.SUPPORTED) {
                    stField.add("presence", (Object)this.getFieldPresence((FieldRefType)member));
                } else {
                    stField.add("presence", (Object)supportedMap.get(((FieldRefType)member).getSupported()));
                }
                stField.add("assign", (Object)((FieldRefType)member).getAssign());
                stField.write(writer, this.templateErrorListener);
                continue;
            }
            if (member instanceof GroupRefType) {
                component = this.getGroup(((GroupRefType)member).getId().intValue());
                stComponent = this.stGroup.getInstanceOf("componentMember");
                stComponent.add("component", (Object)component);
                if (((ComponentRefType)member).getSupported() == SupportType.SUPPORTED) {
                    stComponent.add("presence", (Object)((ComponentRefType)member).getPresence().value().toLowerCase());
                } else {
                    stComponent.add("presence", (Object)supportedMap.get(((ComponentRefType)member).getSupported()));
                }
                stComponent.write(writer, this.templateErrorListener);
                continue;
            }
            if (!(member instanceof ComponentRefType)) continue;
            component = this.getComponent(((ComponentRefType)member).getId().intValue());
            stComponent = this.stGroup.getInstanceOf("componentMember");
            stComponent.add("component", (Object)component);
            if (((ComponentRefType)member).getSupported() == SupportType.SUPPORTED) {
                stComponent.add("presence", (Object)((ComponentRefType)member).getPresence().value().toLowerCase());
            } else {
                stComponent.add("presence", (Object)supportedMap.get(((ComponentRefType)member).getSupported()));
            }
            stComponent.write(writer, this.templateErrorListener);
        }
    }

    private void generateMessageDetail(Path messagesDocPath, Path messagesImgPath, MessageType message) throws Exception {
        ST stMessageStart = this.stGroup.getInstanceOf("messageStart");
        ST stMessagePart2 = this.stGroup.getInstanceOf("messagePart2");
        ST stMessageEnd = this.stGroup.getInstanceOf("messageEnd");
        stMessageStart.add("message", (Object)message);
        stMessagePart2.add("message", (Object)message);
        stMessageEnd.add("message", (Object)message);
        List responses = null;
        MessageType.Responses responses2 = message.getResponses();
        if (responses2 != null) {
            responses = responses2.getResponse();
        }
        List members = message.getStructure().getComponentRefOrGroupRefOrFieldRef();
        Path path = messagesDocPath.resolve(String.format("%s-%s.html", message.getName(), message.getScenario()));
        try (STWriterWrapper writer = this.getWriter(path);){
            stMessageStart.write((STWriter)writer, this.templateErrorListener);
            if (responses != null) {
                this.generateResponses(responses, (STWriter)writer);
            }
            stMessagePart2.write((STWriter)writer, this.templateErrorListener);
            this.generateMembers(members, (STWriter)writer);
            stMessageEnd.write((STWriter)writer, this.templateErrorListener);
        }
        if (responses != null) {
            FlowType flow = this.getFlow(message.getFlow());
            this.imgGenerator.generateUMLSequence(messagesImgPath, this.pathManager, message, flow, responses, this.templateErrorListener);
        }
    }

    private void generateMessageListByCategory(Path messagesDocPath, CategoryType category, List<MessageType> messageList) throws Exception {
        ST st = this.stGroup.getInstanceOf("messages");
        List filteredMessageList = messageList.stream().filter(m -> category.getName().equals(m.getCategory())).collect(Collectors.toList());
        st.add("messages", filteredMessageList);
        st.add("title", (Object)String.format("%s Messages", category.getName()));
        Path path = messagesDocPath.resolve(String.format("%sMessages.html", category.getName()));
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateMessageListByFlow(Path messagesDocPath, FlowType flow, List<MessageType> messageList) throws Exception {
        ST st = this.stGroup.getInstanceOf("messages");
        List filteredMessageList = messageList.stream().filter(m -> flow.getName().equals(m.getFlow())).collect(Collectors.toList());
        st.add("messages", filteredMessageList);
        st.add("title", (Object)String.format("%s Messages", flow.getName()));
        Path path = messagesDocPath.resolve(String.format("%sMessages.html", flow.getName()));
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateMetadata(Path baseOutputPath, Repository repository, List<JAXBElement<SimpleLiteral>> elementList) throws Exception {
        ST st = this.stGroup.getInstanceOf("metadata");
        st.add("repository", (Object)repository);
        st.add("elementList", elementList);
        Path path = baseOutputPath.resolve("metadata.html");
        try (STWriterWrapper writer = this.getWriter(path);){
            st.write((STWriter)writer, this.templateErrorListener);
        }
    }

    private void generateResponses(List<ResponseType> responseList, STWriter writer) {
        for (ResponseType response : responseList) {
            List responses = response.getMessageRefOrAssignOrTrigger();
            for (Object responseRef : responses) {
                if (!(responseRef instanceof MessageRefType)) continue;
                MessageRefType messageRef = (MessageRefType)responseRef;
                ST st = this.stGroup.getInstanceOf("messageResponse");
                st.add("message", (Object)messageRef.getName());
                st.add("scenario", (Object)messageRef.getScenario());
                st.add("when", (Object)response.getWhen());
                st.write(writer, this.templateErrorListener);
            }
        }
    }

    private ComponentType getComponent(int componentId) {
        List components = this.repository.getComponents().getComponent();
        for (ComponentType component : components) {
            if (component.getId().intValue() != componentId) continue;
            return component;
        }
        return null;
    }

    private FieldType getField(int id) {
        List fields = this.repository.getFields().getField();
        for (FieldType fieldType : fields) {
            if (fieldType.getId().intValue() != id) continue;
            return fieldType;
        }
        return null;
    }

    private String getFieldPresence(FieldRefType fieldRef) {
        switch (fieldRef.getPresence()) {
            case CONSTANT: {
                return String.format("constant %s", fieldRef.getValue());
            }
            case FORBIDDEN: {
                return "forbidden";
            }
            case IGNORED: {
                return "ignored";
            }
            case OPTIONAL: {
                List rules = fieldRef.getRule();
                for (FieldRuleType rule : rules) {
                    if (rule.getPresence() != PresenceT.REQUIRED) continue;
                    return String.format("required when %s", rule.getWhen());
                }
                return "optional";
            }
            case REQUIRED: {
                return "required";
            }
        }
        return "";
    }

    private FlowType getFlow(String name) {
        List afList = this.repository.getActors().getActorOrFlow();
        for (Object obj : afList) {
            FlowType flow;
            if (!(obj instanceof FlowType) || !(flow = (FlowType)obj).getName().equals(name)) continue;
            return flow;
        }
        return null;
    }

    private GroupType getGroup(int componentId) {
        List groups = this.repository.getGroups().getGroup();
        for (GroupType group : groups) {
            if (group.getId().intValue() != componentId) continue;
            return group;
        }
        return null;
    }

    private PathManager getPathManager(String path) {
        ZipFileManager zipFileManager = new ZipFileManager();
        if (zipFileManager.isSupported(path)) {
            return zipFileManager;
        }
        return new FileManager();
    }

    private String getTitle() {
        String title = "Orchestra";
        List metadata = this.repository.getMetadata().getAny();
        for (JAXBElement element : metadata) {
            if (!element.getName().getLocalPart().equals("title")) continue;
            title = String.join((CharSequence)" ", ((SimpleLiteral)element.getValue()).getContent());
            break;
        }
        return title;
    }

    private String getTypeLink(String type, String scenario) {
        List datatypes = this.repository.getDatatypes().getDatatype();
        for (Datatype datatype : datatypes) {
            if (!datatype.getName().equals(type)) continue;
            return String.format("../datatypes/%s.html", type);
        }
        return String.format("../datatypes/%s-%s.html", type, scenario);
    }

    private STWriterWrapper getWriter(Path path) throws IOException {
        return new STWriterWrapper(this.pathManager.getWriter(path));
    }

    private Repository unmarshal(InputStream inputStream) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Repository.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        jaxbUnmarshaller.setEventHandler(this.unmarshallerErrorHandler);
        return (Repository)jaxbUnmarshaller.unmarshal(inputStream);
    }

    static {
        supportedMap.put(SupportType.SUPPORTED, "&#10003;");
        supportedMap.put(SupportType.FORBIDDEN, "&#10007;");
        supportedMap.put(SupportType.IGNORED, "&ndash;");
    }

    private static class STWriterWrapper
    extends NoIndentWriter
    implements AutoCloseable {
        STWriterWrapper(Writer out) {
            super(out);
        }

        @Override
        public void close() throws Exception {
            this.out.flush();
        }
    }
}

