/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.docgen;

import io.fixprotocol._2020.orchestra.repository.FlowType;
import io.fixprotocol._2020.orchestra.repository.MessageRefType;
import io.fixprotocol._2020.orchestra.repository.MessageType;
import io.fixprotocol._2020.orchestra.repository.ResponseType;
import io.fixprotocol._2020.orchestra.repository.StateMachineType;
import io.fixprotocol._2020.orchestra.repository.Synchronization;
import io.fixprotocol.orchestra.docgen.PathManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import net.sourceforge.plantuml.SourceStringReader;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class ImgGenerator {
    private final STGroupFile stGroup = new STGroupFile("templates/imggen.stg", '$', '$');

    public void generateUMLStateMachine(Path messagesImgPath, PathManager fileSystemManager, StateMachineType stateMachine, STErrorListener errorListener) throws IOException {
        StringWriter stringWriter = new StringWriter();
        NoIndentWriter writer = new NoIndentWriter((Writer)stringWriter);
        ST stStates = this.stGroup.getInstanceOf("stateMachine");
        stStates.add("stateMachine", (Object)stateMachine);
        stStates.write((STWriter)writer, errorListener);
        String umlString = stringWriter.toString();
        SourceStringReader reader = new SourceStringReader(umlString);
        Path path = messagesImgPath.resolve(String.format("%s.png", stateMachine.getName()));
        OutputStream out = fileSystemManager.getOutputStream(path);
        reader.generateImage(out);
        out.flush();
    }

    public void generateUMLSequence(Path messagesImgPath, PathManager fileSystemManager, MessageType message, FlowType flow, List<ResponseType> responseList, STErrorListener errorListener) throws IOException {
        StringWriter stringWriter = new StringWriter();
        NoIndentWriter writer = new NoIndentWriter((Writer)stringWriter);
        ST stSequence = this.stGroup.getInstanceOf("sequence");
        stSequence.add("message", (Object)message);
        stSequence.add("flow", (Object)flow);
        stSequence.write((STWriter)writer, errorListener);
        this.generateResponses(responseList, (STWriter)writer, errorListener);
        ST stEnd = this.stGroup.getInstanceOf("sequenceEnd");
        stEnd.add("message", (Object)message);
        stEnd.write((STWriter)writer, errorListener);
        String umlString = stringWriter.toString();
        SourceStringReader reader = new SourceStringReader(umlString);
        Path path = messagesImgPath.resolve(String.format("%s-%s.png", message.getName(), message.getScenario()));
        OutputStream out = fileSystemManager.getOutputStream(path);
        reader.generateImage(out);
        out.flush();
    }

    private void generateResponses(List<ResponseType> responseList, STWriter writer, STErrorListener errorListener) {
        for (int i = 0; i < responseList.size(); ++i) {
            ResponseType response = responseList.get(i);
            List responses = response.getMessageRefOrAssignOrTrigger();
            for (int j = 0; j < responses.size(); ++j) {
                Object responseRef = responses.get(j);
                if (!(responseRef instanceof MessageRefType)) continue;
                MessageRefType messageRef = (MessageRefType)responseRef;
                ST st = this.stGroup.getInstanceOf("messageResponse");
                st.add("messageName", (Object)messageRef.getName());
                st.add("scenarioName", (Object)messageRef.getScenario());
                st.add("async", (Object)(response.getSync() == Synchronization.ASYNCHRONOUS ? 1 : 0));
                st.add("name", (Object)response.getName());
                st.add("isFirstAlt", (Object)(i == 0 && responseList.size() > 1 && j == 0 ? 1 : 0));
                st.add("isAlt", (Object)(i != 0 && responseList.size() > 1 && j == 0 ? 1 : 0));
                st.write(writer, errorListener);
            }
        }
    }
}

