/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.docgen;

import io.fixprotocol.orchestra.docgen.PathManager;
import io.fixprotocol.orchestra.docgen.ZipPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ZipFileManager
implements PathManager {
    private static final String TEMP_PREFIX = "temp";
    private static final String ZIP_EXTENSION = ".zip";
    private ZipOutputStream zipOutputStream;
    private OutputStreamWriter zipWriter;

    ZipFileManager() {
    }

    private static long copyStreamToStream(InputStream source, OutputStream sink) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    @Override
    public void close() throws Exception {
        this.zipOutputStream.close();
    }

    @Override
    public long copyStreamToPath(InputStream in, Path path) throws IOException {
        this.zipOutputStream.putNextEntry(this.createZipEntry((ZipPath)path));
        return ZipFileManager.copyStreamToStream(in, this.zipOutputStream);
    }

    @Override
    public OutputStream getOutputStream(Path path) throws IOException {
        this.zipOutputStream.putNextEntry(this.createZipEntry((ZipPath)path));
        return this.zipOutputStream;
    }

    @Override
    public Writer getWriter(Path path) throws IOException {
        this.zipOutputStream.putNextEntry(this.createZipEntry((ZipPath)path));
        return this.zipWriter;
    }

    @Override
    public boolean isSupported(String path) {
        return path.endsWith(ZIP_EXTENSION);
    }

    @Override
    public Path makeDirectory(Path path) throws IOException {
        return path;
    }

    @Override
    public ZipPath makeRootPath(String path) throws IOException {
        this.createZipFile(path);
        return ZipPath.ROOT;
    }

    private ZipEntry createZipEntry(ZipPath path) {
        String name = path.toString();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return new ZipEntry(name);
    }

    private File createZipFile(String path) throws IOException {
        File file = path.contains(TEMP_PREFIX) ? File.createTempFile(TEMP_PREFIX, ZIP_EXTENSION) : new File(path);
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        this.zipWriter = new OutputStreamWriter(this.zipOutputStream);
        return file;
    }
}

