/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.docgen;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

class ZipPath
implements Path {
    private static final String SEPARATOR = "/";
    public static final ZipPath ROOT = new ZipPath("/");
    private final String str;

    public ZipPath(String str) {
        this.str = Objects.requireNonNull(str);
    }

    @Override
    public int compareTo(Path other) {
        return this.str.compareTo(other.toString());
    }

    @Override
    public boolean endsWith(Path other) {
        return this.str.endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String other) {
        return this.str.endsWith(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZipPath other = (ZipPath)obj;
        if (this.str == null) {
            return other.str == null;
        }
        return this.str.equals(other.str);
    }

    @Override
    public Path getFileName() {
        return new ZipPath(this.str.substring(this.str.lastIndexOf(SEPARATOR) + 1));
    }

    @Override
    public FileSystem getFileSystem() {
        return null;
    }

    @Override
    public Path getName(int index) {
        return new ZipPath(this.str.split(SEPARATOR)[index]);
    }

    @Override
    public int getNameCount() {
        return this.str.split(SEPARATOR).length;
    }

    @Override
    public Path getParent() {
        if (this.str.equals(SEPARATOR)) {
            return null;
        }
        return new ZipPath(this.str.substring(0, this.str.lastIndexOf(SEPARATOR)));
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return ROOT;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    @Override
    public boolean isAbsolute() {
        return this.startsWith(ROOT);
    }

    @Override
    public Iterator<Path> iterator() {
        final String[] names = this.str.split(SEPARATOR);
        return new Iterator<Path>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < names.length;
            }

            @Override
            public Path next() {
                ++this.index;
                return new ZipPath(names[this.index - 1]);
            }
        };
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path relativize(Path other) {
        String otherStr = other.toString();
        int beginIndex = otherStr.indexOf(this.str);
        if (beginIndex == -1) {
            return null;
        }
        return new ZipPath(otherStr.substring(this.str.length() + 1));
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.toString().isEmpty()) {
            return this;
        }
        if (this.str.equals(SEPARATOR)) {
            return new ZipPath(this.str + other.toString());
        }
        return new ZipPath(String.join((CharSequence)SEPARATOR, this.str, other.toString()));
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new ZipPath(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        Path parent = this.getParent();
        if (parent == null || other.isAbsolute()) {
            return other;
        }
        if (other.toString().isEmpty()) {
            return parent;
        }
        return new ZipPath(parent.toString() + other.toString());
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(new ZipPath(other));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.str.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        return this.str.startsWith(other);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        String[] names = this.str.split(SEPARATOR);
        return new ZipPath(String.join((CharSequence)SEPARATOR, Arrays.copyOfRange(names, beginIndex, endIndex)));
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return null;
    }

    @Override
    public File toFile() {
        return new File(this.toString());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this;
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException();
    }
}

