/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.repository;

import io.fixprotocol.orchestra.dsl.antlr.Evaluator;
import io.fixprotocol.orchestra.dsl.antlr.ScoreException;
import io.fixprotocol.orchestra.event.EventListener;
import io.fixprotocol.orchestra.event.EventListenerFactory;
import io.fixprotocol.orchestra.event.TeeEventListener;
import io.fixprotocol.orchestra.repository.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RepositoryValidatorImpl {
    static final String REPOSITORY_NAMESPACE = "http://fixprotocol.io/2020/orchestra/repository";
    private int errors = 0;
    private final EventListener eventLogger;
    private int fatalErrors = 0;
    static final Predicate<String> isValidChar = t -> t.length() == 1 && !Character.isWhitespace(t.charAt(0));
    static final Predicate<String> isValidInt = t -> t.chars().allMatch(Character::isDigit);
    static final Predicate<String> isValidString = t -> t.length() > 0 && t.chars().noneMatch(Character::isWhitespace);
    static final Predicate<String> isValidBoolean = t -> t.equals("Y") || t.equals("N");
    static final Predicate<String> isValidName = t -> t.length() > 0 && t.chars().noneMatch(Character::isWhitespace) && Character.isUpperCase(t.charAt(0));
    private static final NamespaceContext nsContext = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String arg0) {
            if ("fixr".equals(arg0)) {
                return RepositoryValidatorImpl.REPOSITORY_NAMESPACE;
            }
            return null;
        }

        @Override
        public String getPrefix(String arg0) {
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String arg0) {
            return null;
        }
    };
    private int warnings = 0;

    public RepositoryValidatorImpl(EventListener eventLogger) {
        this.eventLogger = eventLogger;
    }

    public static EventListener createLogger(OutputStream jsonOutputStream) {
        Logger logger = LogManager.getLogger(RepositoryValidatorImpl.class);
        EventListenerFactory factory = new EventListenerFactory();
        TeeEventListener eventListener = null;
        try {
            eventListener = new TeeEventListener();
            EventListener logEventLogger = factory.getInstance("LOG4J");
            logEventLogger.setResource((Object)logger);
            eventListener.addEventListener(logEventLogger);
            if (jsonOutputStream != null) {
                EventListener jsonEventLogger = factory.getInstance("JSON");
                jsonEventLogger.setResource((Object)jsonOutputStream);
                eventListener.addEventListener(jsonEventLogger);
            }
        }
        catch (Exception e) {
            logger.error("Error creating event listener", (Throwable)e);
        }
        return eventListener;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFatalErrors() {
        return this.fatalErrors;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public boolean validate(InputStream inputStream) {
        ErrorListener errorHandler = new ErrorListener();
        try {
            Document xmlDocument = this.validateSchema(inputStream, errorHandler);
            this.validateCodesets(xmlDocument);
            this.validateExpressions(xmlDocument);
        }
        catch (Exception e) {
            this.eventLogger.fatal("Failed to validate Score expressions, {0}", new Object[]{e.getMessage()});
            ++this.fatalErrors;
        }
        if (this.getErrors() + this.getFatalErrors() > 0) {
            this.eventLogger.fatal("RepositoryValidator complete; fatal errors={0,number,integer} errors={1,number,integer} warnings={2,number,integer}", new Object[]{this.getFatalErrors(), this.getErrors(), this.getWarnings()});
            return false;
        }
        this.eventLogger.info("RepositoryValidator complete; fatal errors={0,number,integer} errors={1,number,integer} warnings={2,number,integer}", new Object[]{this.getFatalErrors(), this.getErrors(), this.getWarnings()});
        return true;
    }

    private void closeLogger() {
        try {
            this.eventLogger.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateCodes(NodeList codeElements, Element codesetElement, Predicate<String> isCodeValid) {
        for (int i = 0; i < codeElements.getLength(); ++i) {
            Element codeElement = (Element)codeElements.item(i);
            String value = codeElement.getAttribute("value");
            String codeName = codeElement.getAttribute("name");
            String codesetName = codesetElement.getAttribute("name");
            String codesetId = codesetElement.getAttribute("id");
            if (!isValidName.test(codeName)) {
                ++this.warnings;
                this.eventLogger.warn("RepositoryValidator: code name {0} has invalid case in codeset {1} (id={2})", new Object[]{codeName, codesetName, codesetId});
            }
            if (isCodeValid.test(value)) continue;
            String datatype = codesetElement.getAttribute("type");
            ++this.errors;
            this.eventLogger.error("RepositoryValidator: code {0} value [{1}] is invalid for datatype {2} in codeset {3} (id={4})", new Object[]{codeName, value, datatype, codesetName, codesetId});
        }
    }

    private void validateCodesets(Document xmlDocument) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(nsContext);
        String expression = "//fixr:codeSet";
        try {
            NodeList nodeList = (NodeList)xPath.compile("//fixr:codeSet").evaluate(xmlDocument, XPathConstants.NODESET);
            block17: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node codesetNode = nodeList.item(i);
                short nodeType = codesetNode.getNodeType();
                if (nodeType != 1) continue;
                Element codesetElement = (Element)codesetNode;
                String codesetName = codesetElement.getAttribute("name");
                String codesetId = codesetElement.getAttribute("id");
                String datatype = codesetElement.getAttribute("type");
                NodeList codeElements = codesetElement.getElementsByTagNameNS(REPOSITORY_NAMESPACE, "code");
                switch (datatype) {
                    case "int": 
                    case "NumInGroup": {
                        this.validateCodes(codeElements, codesetElement, isValidInt);
                        continue block17;
                    }
                    case "char": 
                    case "MultipleCharValue": {
                        this.validateCodes(codeElements, codesetElement, isValidChar);
                        continue block17;
                    }
                    case "String": 
                    case "MultipleStringValue": {
                        this.validateCodes(codeElements, codesetElement, isValidString);
                        continue block17;
                    }
                    case "Boolean": {
                        this.validateCodes(codeElements, codesetElement, isValidBoolean);
                        continue block17;
                    }
                    default: {
                        ++this.errors;
                        this.eventLogger.error("RepositoryValidator: unexpected datatype {0} for code set {1} (id={2})", new Object[]{datatype, codesetName, codesetId});
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            this.eventLogger.error("Failed to locate Score expressions");
            this.eventLogger.fatal(e.getMessage());
            ++this.fatalErrors;
        }
    }

    private void validateExpressions(Document xmlDocument) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(nsContext);
        String expression = "//fixr:when";
        try {
            NodeList nodeList = (NodeList)xPath.compile("//fixr:when").evaluate(xmlDocument, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                short nodeType = node.getNodeType();
                if (nodeType != 1) continue;
                Element element = (Element)node;
                String condition = element.getTextContent();
                try {
                    Evaluator.validateSyntax((String)condition);
                    continue;
                }
                catch (ScoreException exception) {
                    this.eventLogger.error("RepositoryValidator: invalid Score expression '{0}'; {1} at col. {2}", new Object[]{condition, exception.getMessage(), exception.getColumnNumber()});
                    ++this.errors;
                }
            }
        }
        catch (XPathExpressionException e) {
            this.eventLogger.error("Failed to locate Score expressions");
            this.eventLogger.fatal(e.getMessage());
            ++this.fatalErrors;
        }
    }

    private Document validateSchema(InputStream inputStream, ErrorListener errorHandler) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setXIncludeAware(true);
        DocumentBuilder parser = parserFactory.newDocumentBuilder();
        Document document = parser.parse(inputStream);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        ResourceResolver resourceResolver = new ResourceResolver();
        factory.setResourceResolver(resourceResolver);
        URL resourceUrl = this.getClass().getClassLoader().getResource("xsd/repository.xsd");
        String path = Objects.requireNonNull(resourceUrl).getPath();
        String parentPath = path.substring(0, path.lastIndexOf(47));
        URL baseUrl = new URL(resourceUrl.getProtocol(), null, parentPath);
        resourceResolver.setBaseUrl(baseUrl);
        StreamSource schemaFile = new StreamSource(resourceUrl.openStream());
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(errorHandler);
        validator.validate(new DOMSource(document));
        return document;
    }

    private final class ErrorListener
    implements ErrorHandler {
        private ErrorListener() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            RepositoryValidatorImpl.this.eventLogger.error("RepositoryValidator: XML error at line {0} col {1} {2}", new Object[]{exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
            RepositoryValidatorImpl.this.errors++;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            RepositoryValidatorImpl.this.eventLogger.fatal("RepositoryValidator: XML fatal error at line {0} col {1} {2}", new Object[]{exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
            RepositoryValidatorImpl.this.fatalErrors++;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            RepositoryValidatorImpl.this.eventLogger.warn("RepositoryValidator: XML warning at line {0} col {1} {2}", new Object[]{exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
            RepositoryValidatorImpl.this.warnings++;
        }
    }
}

