/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.transformers;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public class Unified2OrchestraTransformer {
    public static void main(String[] args) throws TransformerException {
        if (args.length < 3) {
            System.out.println("Usage: Unified2OrchestraTransformer <input_xml_file_path> <phrases_file_path> <output_file_path>");
            return;
        }
        Unified2OrchestraTransformer transformer = new Unified2OrchestraTransformer();
        transformer.transform(args);
    }

    public void transform(File inputXml, File phrasesFile, File outputXml, String name, String version) throws TransformerException {
        File parentFile = outputXml.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        StreamSource xmlSource = new StreamSource(inputXml);
        InputStream xsltFile = this.getClass().getClassLoader().getResourceAsStream("xsl/unified2orchestra.xslt");
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(outputXml);
        TransformerFactoryImpl transFact = new TransformerFactoryImpl();
        Transformer trans = transFact.newTransformer(xsltSource);
        trans.setParameter("phrases-file", phrasesFile.toURI().toString());
        trans.setParameter("name", name);
        trans.setParameter("new-version", version);
        trans.transform(xmlSource, result);
    }

    private void transform(String[] args) throws TransformerException {
        File inputXml = new File(args[0]);
        File phrasesFile = new File(args[1]);
        File outputXml = new File(args[2]);
        this.transform(inputXml, phrasesFile, outputXml, args[3], args[4]);
    }
}

