/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.flagsmith.internal.FlagsmithAnalytics;
import com.flagsmith.internal.FlagsmithRetrofitService;
import com.flagsmith.internal.FlagsmithRetrofitServiceKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004*\u0001\u0010\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00142\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/flagsmith/internal/FlagsmithAnalytics;", "", "context", "Landroid/content/Context;", "retrofitService", "Lcom/flagsmith/internal/FlagsmithRetrofitService;", "flushPeriod", "", "(Landroid/content/Context;Lcom/flagsmith/internal/FlagsmithRetrofitService;I)V", "applicationContext", "currentEvents", "", "", "timerHandler", "Landroid/os/Handler;", "timerRunnable", "com/flagsmith/internal/FlagsmithAnalytics$timerRunnable$1", "Lcom/flagsmith/internal/FlagsmithAnalytics$timerRunnable$1;", "getMap", "resetMap", "", "setMap", "updateMap", "", "trackEvent", "flagName", "Companion", "FlagsmithClient_release"})
public final class FlagsmithAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final FlagsmithRetrofitService retrofitService;
    private final int flushPeriod;
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Map<String, Integer> currentEvents;
    @NotNull
    private final Handler timerHandler;
    @NotNull
    private final timerRunnable.1 timerRunnable;
    @NotNull
    private static final String EVENTS_KEY = "events";

    public FlagsmithAnalytics(@NotNull Context context, @NotNull FlagsmithRetrofitService retrofitService, int flushPeriod) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)retrofitService, (String)"retrofitService");
        this.context = context;
        this.retrofitService = retrofitService;
        this.flushPeriod = flushPeriod;
        Context context2 = this.context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.applicationContext = context2;
        this.currentEvents = this.getMap();
        this.timerHandler = new Handler(Looper.getMainLooper());
        this.timerRunnable = new Runnable(this){
            final /* synthetic */ FlagsmithAnalytics this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                if (!FlagsmithAnalytics.access$getCurrentEvents$p(this.this$0).isEmpty()) {
                    FlagsmithRetrofitServiceKt.enqueueWithResult$default(FlagsmithAnalytics.access$getRetrofitService$p(this.this$0).postAnalytics(FlagsmithAnalytics.access$getCurrentEvents$p(this.this$0)), null, (Function1)new Function1<Result<? extends Unit>, Unit>(this.this$0){
                        final /* synthetic */ FlagsmithAnalytics this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Object result) {
                            block1: {
                                Object object = result;
                                Object object2 = this.this$0;
                                if (Result.isSuccess-impl((Object)object)) {
                                    Unit it = (Unit)object;
                                    boolean bl = false;
                                    FlagsmithAnalytics.access$resetMap((FlagsmithAnalytics)object2);
                                }
                                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                                if (throwable == null) break block1;
                                Object err = object2 = throwable;
                                boolean bl = false;
                                Log.e((String)"FLAGSMITH", (String)("Failed posting analytics - " + ((Throwable)err).getLocalizedMessage()));
                            }
                        }
                    }, 1, null);
                }
                FlagsmithAnalytics.access$getTimerHandler$p(this.this$0).postDelayed((Runnable)this, (long)FlagsmithAnalytics.access$getFlushPeriod$p(this.this$0) * (long)1000);
            }
        };
        this.timerHandler.post((Runnable)this.timerRunnable);
    }

    public final void trackEvent(@NotNull String flagName) {
        Intrinsics.checkNotNullParameter((Object)flagName, (String)"flagName");
        Integer n = this.currentEvents.get(flagName);
        int currentFlagCount = n != null ? n : 0;
        this.currentEvents.put(flagName, currentFlagCount + 1);
        this.setMap(this.currentEvents);
    }

    private final void setMap(Map<String, Integer> updateMap) {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(EVENTS_KEY, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EY, Context.MODE_PRIVATE)");
        SharedPreferences pSharedPref = sharedPreferences;
        JSONObject jsonObject = new JSONObject(updateMap);
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        String jsonString = string;
        pSharedPref.edit().remove(EVENTS_KEY).putString(EVENTS_KEY, jsonString).apply();
    }

    private final Map<String, Integer> getMap() {
        Map outputMap = new HashMap();
        SharedPreferences sharedPreferences = this.applicationContext.getSharedPreferences(EVENTS_KEY, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"applicationContext.getSh\u2026EY, Context.MODE_PRIVATE)");
        SharedPreferences pSharedPref = sharedPreferences;
        try {
            String jsonString = pSharedPref.getString(EVENTS_KEY, new JSONObject().toString());
            if (jsonString != null) {
                JSONObject jsonObject = new JSONObject(jsonString);
                Iterator keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String key = (String)keysItr.next();
                    int value = jsonObject.getInt(key);
                    Integer n = value;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    outputMap.put(key, n);
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)"FLAGSMITH", (String)("Exception in getMap Analytics - " + ExceptionsKt.stackTraceToString((Throwable)e)));
        }
        return outputMap;
    }

    private final void resetMap() {
        this.currentEvents.clear();
        this.setMap(this.currentEvents);
    }

    public static final /* synthetic */ Map access$getCurrentEvents$p(FlagsmithAnalytics $this) {
        return $this.currentEvents;
    }

    public static final /* synthetic */ FlagsmithRetrofitService access$getRetrofitService$p(FlagsmithAnalytics $this) {
        return $this.retrofitService;
    }

    public static final /* synthetic */ void access$resetMap(FlagsmithAnalytics $this) {
        $this.resetMap();
    }

    public static final /* synthetic */ Handler access$getTimerHandler$p(FlagsmithAnalytics $this) {
        return $this.timerHandler;
    }

    public static final /* synthetic */ int access$getFlushPeriod$p(FlagsmithAnalytics $this) {
        return $this.flushPeriod;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/flagsmith/internal/FlagsmithAnalytics$Companion;", "", "()V", "EVENTS_KEY", "", "FlagsmithClient_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

