/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.base;

import io.floodplain.streams.base.RocksDBConfigurationSetter;
import java.util.Map;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedMemoryRocksDBConfig
implements RocksDBConfigSetter {
    private static final long BLOCK_SIZE = 1000L;
    private static final long DEFAULT_TOTAL_OFF_HEAP_MEMORY = 50000000L;
    private static final double INDEX_FILTER_BLOCK_RATIO = 0.5;
    private static final int N_MEMTABLES = 100;
    private static final long MEMTABLE_SIZE = 20000L;
    private static Cache cache = new LRUCache(BoundedMemoryRocksDBConfig.totalOffHeapMemory(), -1, false, 0.5);
    private static final long DEFAULT_TOTAL_MEMTABLE_MEMORY = 50000000L;
    private static WriteBufferManager writeBufferManager = new WriteBufferManager(BoundedMemoryRocksDBConfig.totalMemtableMemory(), cache);
    private static final Logger logger = LoggerFactory.getLogger(RocksDBConfigurationSetter.class);

    private static long totalOffHeapMemory() {
        String offHeapTotalEnv = System.getenv("TOTAL_OFF_HEAP_MEMORY");
        long offHeapTotal = 50000000L;
        if (offHeapTotalEnv != null) {
            try {
                offHeapTotal = Long.parseLong(offHeapTotalEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_WRITE_BUFFER_SIZE ({}) - using default of {}", new Object[]{offHeapTotalEnv, offHeapTotal, t});
            }
        }
        return offHeapTotal;
    }

    private static long totalMemtableMemory() {
        String totalMemtableMemoryEnv = System.getenv("TOTAL_OFF_HEAP_MEMORY");
        long totalMemtableMemory = 50000000L;
        if (totalMemtableMemoryEnv != null) {
            try {
                totalMemtableMemory = Long.parseLong(totalMemtableMemoryEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse TOTAL_OFF_HEAP_MEMORY ({}) - using default of {}", new Object[]{totalMemtableMemoryEnv, totalMemtableMemory, t});
            }
        }
        return totalMemtableMemory;
    }

    public void setConfig(String storeName, Options options, Map<String, Object> configs) {
        BlockBasedTableConfig tableConfig = (BlockBasedTableConfig)options.tableFormatConfig();
        tableConfig.setBlockCache(cache);
        tableConfig.setCacheIndexAndFilterBlocks(true);
        options.setWriteBufferManager(writeBufferManager);
        tableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
        tableConfig.setPinTopLevelIndexAndFilter(true);
        tableConfig.setBlockSize(1000L);
        options.setMaxWriteBufferNumber(100);
        options.setWriteBufferSize(20000L);
        options.setTableFormatConfig((TableFormatConfig)tableConfig);
    }

    public void close(String storeName, Options options) {
    }
}

