/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.base;

import java.util.Map;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBConfigurationSetter
implements RocksDBConfigSetter {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBConfigurationSetter.class);
    private static final long DEFAULT_WRITE_BUFFER_SIZE = 0x500000L;
    private static final long DEFAULT_BLOCK_CACHE_SIZE = 0x500000L;
    private static final long DEFAULT_BLOCK_SIZE = 4096L;
    private static final int DEFAULT_L0_FILES = 10;
    private static final int DEFAULT_STATS_DUMP_PERIOD_SEC = 3600;
    private static final int BITS_PER_KEY = 10;

    public void setConfig(final String storeName, Options options, Map<String, Object> configs) {
        options.setWriteBufferSize(this.getWriteBufferSize());
        BlockBasedTableConfig tableConfig = (BlockBasedTableConfig)options.tableFormatConfig();
        tableConfig.setBlockCacheSize(this.getBlockCacheSize());
        tableConfig.setBlockSize(this.getBlockSize());
        if ("true".equalsIgnoreCase(System.getenv("ROCKSDB_USE_BLOOMFILTER"))) {
            tableConfig.setFilter((Filter)new BloomFilter(10));
        }
        options.setTableFormatConfig((TableFormatConfig)tableConfig);
        options.setLevel0FileNumCompactionTrigger(this.getL0NumFiles());
        options.setCompressionType(CompressionType.LZ4_COMPRESSION);
        options.setStatsDumpPeriodSec(this.getDumpStatsPeriodSec());
        options.setBaseBackgroundCompactions(2);
        options.setInfoLogLevel(InfoLogLevel.WARN_LEVEL);
        options.setLogger(new org.rocksdb.Logger(options){

            protected void log(InfoLogLevel loglevel, String value) {
                logger.debug("storeName: {}, loglevel {}, value {}", new Object[]{storeName, loglevel, value});
            }
        });
    }

    private long getWriteBufferSize() {
        String writeBufferSizeEnv = System.getenv("ROCKSDB_WRITE_BUFFER_SIZE");
        long writeBufferSize = 0x500000L;
        if (writeBufferSizeEnv != null) {
            try {
                writeBufferSize = Long.parseLong(writeBufferSizeEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_WRITE_BUFFER_SIZE ({}) - using default of {}", new Object[]{writeBufferSizeEnv, writeBufferSize, t});
            }
        }
        return writeBufferSize;
    }

    private long getBlockSize() {
        String blockSizeEnv = System.getenv("ROCKSDB_BLOCK_SIZE");
        long blocksize = 4096L;
        if (blockSizeEnv != null) {
            try {
                blocksize = Long.parseLong(blockSizeEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_BLOCK_SIZE ({}) - using default of {}", new Object[]{blockSizeEnv, blockSizeEnv, t});
            }
        }
        return blocksize;
    }

    private long getBlockCacheSize() {
        String blockCacheSizeEnv = System.getenv("ROCKSDB_BLOCK_CACHE_SIZE");
        long blockcachesize = 0x500000L;
        if (blockCacheSizeEnv != null) {
            try {
                blockcachesize = Long.parseLong(blockCacheSizeEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_BLOCK_CACHE_SIZE ({}) - using default of {}", new Object[]{blockCacheSizeEnv, blockcachesize, t});
            }
        }
        return blockcachesize;
    }

    private int getL0NumFiles() {
        String l0numfilesEnv = System.getenv("ROCKSDB_L0_NUMFILES");
        int l0numfiles = 10;
        if (l0numfilesEnv != null) {
            try {
                l0numfiles = Integer.parseInt(l0numfilesEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_L0_NUMFILES ({}) - using default of {}", new Object[]{l0numfilesEnv, l0numfiles, t});
            }
        }
        return l0numfiles;
    }

    private int getDumpStatsPeriodSec() {
        String dumpperiodsecEnv = System.getenv("ROCKSDB_DUMP_PERIOD_SEC");
        int dumpperiodsec = 3600;
        if (dumpperiodsecEnv != null) {
            try {
                dumpperiodsec = Integer.parseInt(dumpperiodsecEnv.trim());
            }
            catch (Throwable t) {
                logger.warn("Unable to parse ROCKSDB_DUMP_PERIOD_SEC ({}) - using default of {}", new Object[]{dumpperiodsecEnv, dumpperiodsec, t});
            }
        }
        return dumpperiodsec;
    }
}

