/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.debezium;

import io.floodplain.immutable.api.ImmutableMessage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TableIdentifier {
    public final String deployment;
    public final Optional<String> tenant;
    public final Optional<String> databaseInstance;
    public final String table;
    public final ImmutableMessage keyMessage;
    public final String combinedKey;
    public final List<String> fields;

    public TableIdentifier(String tableId, ImmutableMessage keyMessage, List<String> fields) {
        String[] primary = tableId.split("\\.");
        this.keyMessage = keyMessage;
        LinkedList<String> l = new LinkedList<String>(fields);
        this.fields = Collections.unmodifiableList(l);
        if (!primary[1].contains("_")) {
            this.tenant = Optional.empty();
            this.table = primary[2];
            this.deployment = primary[0];
            this.databaseInstance = Optional.empty();
            this.combinedKey = fields.stream().map(arg_0 -> ((ImmutableMessage)keyMessage).value(arg_0)).filter(Optional::isPresent).map(e -> e.get().toString()).collect(Collectors.joining("<$>"));
        } else {
            this.deployment = primary[0];
            String[] secondary = primary[1].split("_");
            this.tenant = Optional.of(secondary[0].toUpperCase());
            this.databaseInstance = Optional.of(secondary[1].toUpperCase());
            this.table = primary[2];
            this.combinedKey = fields.stream().map(arg_0 -> ((ImmutableMessage)keyMessage).value(arg_0)).filter(Optional::isPresent).map(e -> e.get().toString()).collect(Collectors.joining("<$>"));
        }
    }
}

