/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.remotejoin;

import io.floodplain.replication.api.ReplicationMessage;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfElseProcessor
implements Processor<String, ReplicationMessage, String, ReplicationMessage> {
    private static final Logger logger = LoggerFactory.getLogger(IfElseProcessor.class);
    private final Predicate<ReplicationMessage> condition;
    private final String ifTrueProcessorName;
    private final Optional<String> ifFalseProcessorName;
    private ProcessorContext<String, ReplicationMessage> context;

    public IfElseProcessor(Predicate<ReplicationMessage> condition, String ifTrueProcessorName, Optional<String> ifFalseProcessorName) {
        this.condition = condition;
        this.ifTrueProcessorName = ifTrueProcessorName;
        this.ifFalseProcessorName = ifFalseProcessorName;
    }

    private void forwardToFalse(String key, ReplicationMessage value, long timestamp, String e) {
        this.context.forward(new Record((Object)key, (Object)value.withOperation(ReplicationMessage.Operation.NONE), timestamp), e);
    }

    public void process(Record<String, ReplicationMessage> record) {
        ReplicationMessage value = (ReplicationMessage)record.value();
        String key = (String)record.key();
        if (value == null) {
            logger.warn("Ignoring null-message in ifelseprocessor with key: {}", (Object)key);
            return;
        }
        boolean res = this.condition.test(value);
        if (res) {
            this.context.forward(new Record((Object)key, (Object)value, record.timestamp()), this.ifTrueProcessorName);
        } else {
            this.ifFalseProcessorName.ifPresent(e -> this.forwardToFalse(key, value, record.timestamp(), (String)e));
        }
    }

    public void init(ProcessorContext<String, ReplicationMessage> context) {
        this.context = context;
    }
}

