/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.remotejoin;

import io.floodplain.replication.api.ReplicationMessage;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;

public class PreJoinProcessor
implements Processor<String, ReplicationMessage, String, ReplicationMessage> {
    public static final String REVERSE_IDENTIFIER = "_REV_";
    private final boolean isReverseJoin;
    private ProcessorContext<String, ReplicationMessage> context;

    public PreJoinProcessor(boolean isReverseJoin) {
        this.isReverseJoin = isReverseJoin;
    }

    public void process(Record<String, ReplicationMessage> record) {
        ReplicationMessage msg = (ReplicationMessage)record.value();
        if (this.isReverseJoin) {
            Object newKey = (String)record.key();
            newKey = (String)newKey + REVERSE_IDENTIFIER;
            this.context.forward(record.withKey(newKey).withValue((Object)(msg == null ? null : msg.withoutParamMessage())));
        } else {
            this.context.forward(record.withValue((Object)(msg == null ? null : msg.withoutParamMessage())));
        }
    }

    public void init(ProcessorContext<String, ReplicationMessage> context) {
        this.context = context;
    }
}

