/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.remotejoin;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.factory.ReplicationFactory;
import java.util.Optional;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueStore;

public class StoreStateProcessor
implements Processor<String, ReplicationMessage, String, ReplicationMessage> {
    private final String lookupStoreName;
    private KeyValueStore<String, ImmutableMessage> lookupStore;
    public static final String COMMONKEY = "singlerestore";
    private ProcessorContext<String, ReplicationMessage> context;

    public StoreStateProcessor(String lookupStoreName) {
        this.lookupStoreName = lookupStoreName;
    }

    public void init(ProcessorContext<String, ReplicationMessage> context) {
        this.context = context;
        this.lookupStore = (KeyValueStore)context.getStateStore(this.lookupStoreName);
    }

    public void process(Record<String, ReplicationMessage> record) {
        String key = (String)record.key();
        ReplicationMessage inputValue = (ReplicationMessage)record.value();
        Optional paramMessage = inputValue.paramMessage();
        if (paramMessage.isEmpty()) {
            throw new RuntimeException("In store state there should definitely be a secondary message");
        }
        ImmutableMessage storeMessage = (ImmutableMessage)paramMessage.get();
        this.lookupStore.put((Object)key, (Object)storeMessage);
        this.context.forward(new Record((Object)key, (Object)ReplicationFactory.standardMessage((ImmutableMessage)storeMessage), record.timestamp()));
    }
}

