/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.remotejoin;

import io.floodplain.immutable.api.ImmutableMessage;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.streams.api.Topic;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyConstructor {
    private static final Logger logger = LoggerFactory.getLogger(TopologyConstructor.class);
    public final Map<String, List<String>> processorStateStoreMapper = new HashMap<String, List<String>>();
    public final Map<String, StoreBuilder<KeyValueStore<String, ReplicationMessage>>> stateStoreSupplier = new HashMap<String, StoreBuilder<KeyValueStore<String, ReplicationMessage>>>();
    public final Map<String, StoreBuilder<KeyValueStore<String, ImmutableMessage>>> immutableStoreSupplier = new HashMap<String, StoreBuilder<KeyValueStore<String, ImmutableMessage>>>();
    public final Map<String, StoreBuilder<KeyValueStore<String, Long>>> longStoreSupplier = new HashMap<String, StoreBuilder<KeyValueStore<String, Long>>>();
    public final Set<String> stores = new HashSet<String>();
    public final Set<String> sinks = new HashSet<String>();
    public final Map<Topic, String> sources = new HashMap<Topic, String>();
    private final Map<Topic, Optional<Integer>> desiredTopics = new HashMap<Topic, Optional<Integer>>();
    private int streamCounter = 1;

    public void addDesiredTopic(Topic topic, Optional<Integer> partitions) {
        if (!this.desiredTopics.containsKey(topic) || partitions.isPresent()) {
            this.desiredTopics.put(topic, partitions);
        }
    }

    public Set<Topic> desiredTopicNames() {
        return this.desiredTopics.keySet();
    }

    public void ensureTopicExists(Topic topicName, Optional<Integer> partitionCount) {
        this.desiredTopics.put(topicName, partitionCount);
    }

    public void createTopicsAsNeeded(Map<String, Object> settings) {
        HashMap<String, Object> config = new HashMap<String, Object>(settings);
        config.put("client.id", UUID.randomUUID().toString());
        config.put("cleanup.policy", "compact");
        AdminClient adminClient = AdminClient.create(config);
        HashSet topics = new HashSet();
        logger.info("Required topics: {}", this.desiredTopics);
        try {
            topics.addAll((Collection)adminClient.listTopics().names().get());
        }
        catch (InterruptedException | ExecutionException e2) {
            throw new RuntimeException("Error listing topics", e2);
        }
        List toBeCreated = this.desiredTopics.entrySet().stream().filter(e -> !topics.contains(((Topic)e.getKey()).qualifiedString())).map(e -> this.createTopic((Topic)e.getKey(), (Optional)e.getValue())).collect(Collectors.toList());
        logger.info("Creating missing topics: {}", (Object)toBeCreated.stream().map(e -> e.name()).collect(Collectors.joining(",")));
        try {
            adminClient.createTopics(toBeCreated).all().get();
        }
        catch (InterruptedException | ExecutionException e3) {
            throw new RuntimeException("Issue creating topics: " + this.desiredTopics.keySet(), e3);
        }
        finally {
            adminClient.close();
        }
    }

    private NewTopic createTopic(Topic topic, Optional<Integer> partitions) {
        int effectivePartitions = partitions.orElse(1);
        NewTopic result = new NewTopic(topic.qualifiedString(), Optional.of(effectivePartitions), Optional.empty());
        return result.configs(Map.of("cleanup.policy", "compact"));
    }

    public int generateNewStreamId() {
        return this.streamCounter++;
    }

    public void addSink(String qualifiedName) {
        this.sinks.add(qualifiedName);
    }
}

