/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.streams.debezium.DebeziumParseException;
import io.floodplain.streams.debezium.JSONToReplicationMessage;
import io.floodplain.streams.debezium.TableIdentifier;
import io.floodplain.streams.serializer.ConnectKeySerializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectReplicationMessageSerde
implements Serde<ReplicationMessage> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectReplicationMessageSerde.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
    private static final ConnectKeySerializer keySerializer = new ConnectKeySerializer();

    public void close() {
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    private static String parseConnectKey(byte[] input) throws IOException {
        JsonNode jsonNode = objectMapper.readTree(input);
        ObjectNode node = (ObjectNode)jsonNode;
        TableIdentifier id = JSONToReplicationMessage.processDebeziumKey(node);
        return id.combinedKey;
    }

    public static Serializer<String> keySerialize() {
        return keySerializer;
    }

    public static Deserializer<String> keyDeserialize() {
        return new Deserializer<String>(){

            public void close() {
            }

            public void configure(Map<String, ?> config, boolean isKey) {
                logger.info("Configuring key deserializer: {}", config);
            }

            public String deserialize(String topic, byte[] data) {
                try {
                    return ConnectReplicationMessageSerde.parseConnectKey(data);
                }
                catch (IOException e) {
                    String raw = new String(data, StandardCharsets.UTF_8);
                    throw new RuntimeException("Error deserializing key: " + raw, e);
                }
            }
        };
    }

    public Deserializer<ReplicationMessage> deserializer() {
        return new Deserializer<ReplicationMessage>(){

            public void close() {
            }

            public void configure(Map<String, ?> config, boolean isKey) {
                logger.info("Configuring deserializer: {}", config);
            }

            public ReplicationMessage deserialize(String topic, byte[] data) {
                try {
                    return JSONToReplicationMessage.processDebeziumBody(data, Optional.of(topic));
                }
                catch (DebeziumParseException e) {
                    throw new RuntimeException("Error parsing replmessage", e);
                }
            }
        };
    }

    public Serializer<ReplicationMessage> serializer() {
        boolean schemaEnable = false;
        boolean debug = false;
        return new Serializer<ReplicationMessage>(){

            public void close() {
            }

            public void configure(Map<String, ?> configs, boolean isKey) {
                logger.info("Configuring: {}", configs);
            }

            public byte[] serialize(String topic, ReplicationMessage replMessage) {
                if (replMessage == null || replMessage.operation() == ReplicationMessage.Operation.DELETE) {
                    return null;
                }
                Map valueMap = replMessage.valueMap(true, Collections.emptySet());
                try {
                    byte[] val = objectMapper.writeValueAsBytes((Object)valueMap);
                    return val;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Json issue", e);
                }
            }
        };
    }
}

