/*
 * Decompiled with CFR 0.152.
 */
package io.floodplain.streams.serializer;

import io.floodplain.replication.api.ReplicationMessage;
import io.floodplain.replication.api.ReplicationMessageParser;
import io.floodplain.replication.factory.ReplicationFactory;
import io.floodplain.replication.impl.protobuf.FallbackReplicationMessageParser;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMessageSerde
implements Serde<ReplicationMessage> {
    private final FallbackReplicationMessageParser parser = new FallbackReplicationMessageParser();
    private static final Logger logger = LoggerFactory.getLogger(ReplicationMessageSerde.class);

    public ReplicationMessageSerde() {
        ReplicationFactory.setInstance((ReplicationMessageParser)this.parser);
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public Deserializer<ReplicationMessage> deserializer() {
        return new Deserializer<ReplicationMessage>(){

            public void close() {
            }

            public void configure(Map<String, ?> config, boolean isKey) {
                logger.info("Configuring deserializer: {}", config);
            }

            public ReplicationMessage deserialize(String topic, byte[] data) {
                return ReplicationMessageSerde.this.parser.parseBytes(Optional.of(topic), data);
            }
        };
    }

    public Serializer<ReplicationMessage> serializer() {
        return new Serializer<ReplicationMessage>(){

            public void close() {
            }

            public void configure(Map<String, ?> configs, boolean isKey) {
                logger.info("Configuring: {}", configs);
            }

            public byte[] serialize(String topic, ReplicationMessage data) {
                if (data == null) {
                    return null;
                }
                return data.toBytes((ReplicationMessageParser)ReplicationMessageSerde.this.parser);
            }
        };
    }
}

