/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.QueryOptions;
import com.flowthings.client.api.MutableDomainObjectApi;
import com.flowthings.client.api.Request;
import com.flowthings.client.api.SubscriptionCallback;
import com.flowthings.client.domain.Drop;
import java.util.List;
import java.util.regex.Pattern;

public class DropApi
extends MutableDomainObjectApi<Drop> {
    private static final Pattern FLOW_ID_PATTERN = Pattern.compile("f[0-9a-f]{24}");
    private String flowId;

    DropApi(String flowId) {
        super(Drop.class);
        if (!FLOW_ID_PATTERN.matcher(flowId).matches()) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid flow id", flowId));
        }
        this.flowId = flowId;
    }

    @Override
    public Request<Drop> get(String id) {
        return super.get(id).flowId(this.flowId);
    }

    @Override
    public Request<List<Drop>> find(QueryOptions queryOptions) {
        return super.find(queryOptions).flowId(this.flowId);
    }

    @Override
    public Request<Drop> create(Drop t) {
        return super.create(t).flowId(this.flowId);
    }

    @Override
    public Request<Drop> update(String id, Drop t) {
        return super.update(id, t).flowId(this.flowId);
    }

    @Override
    public Request<Drop> delete(String id) {
        return super.delete(id).flowId(this.flowId);
    }

    public Request<Drop> deleteAll() {
        return Request.createObjectRequest(this.clazz, Request.Action.DELETE).flowId(this.flowId);
    }

    public Request<Drop> subscribe(SubscriptionCallback<Drop> callback) {
        return Request.createObjectRequest(this.clazz, Request.Action.SUBSCRIBE).flowId(this.flowId).addData("callback", callback);
    }

    public Request<Drop> unsubscribe() {
        return Request.createObjectRequest(this.clazz, Request.Action.UNSUBSCRIBE).flowId(this.flowId);
    }
}

