/*
 * Decompiled with CFR 0.152.
 */
package com.flowthings.client.api;

import com.flowthings.client.exception.AsyncException;
import com.flowthings.client.exception.FlowthingsException;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FlowthingsFuture<T>
implements Future<T> {
    private final Future<T> inner;

    public FlowthingsFuture(Future<T> inner) {
        this.inner = inner;
    }

    public static <S> FlowthingsFuture<S> fromResult(S result) {
        return new FlowthingsFuture(Futures.immediateFuture(result));
    }

    public static <S> FlowthingsFuture<S> fromException(FlowthingsException e) {
        return new FlowthingsFuture(Futures.immediateFailedFuture((Throwable)e));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.inner.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.inner.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.inner.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.inner.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.inner.get(timeout, unit);
    }

    public T grab() throws FlowthingsException {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            throw new AsyncException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FlowthingsException) {
                throw (FlowthingsException)cause;
            }
            throw new FlowthingsException(cause);
        }
    }
}

