/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.assertj.custom;

import io.fluentlenium.assertj.custom.AbstractFluentAssert;
import io.fluentlenium.assertj.custom.FluentListSizeBuilder;
import io.fluentlenium.assertj.custom.ListAttributeAssert;
import io.fluentlenium.assertj.custom.ListStateAssert;
import io.fluentlenium.core.domain.FluentList;
import io.fluentlenium.core.domain.FluentWebElement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.ListAssert;
import org.openqa.selenium.Dimension;

public class FluentListAssert
extends AbstractFluentAssert<FluentListAssert, FluentList>
implements ListStateAssert,
ListAttributeAssert {
    public FluentListAssert(FluentList<? extends FluentWebElement> actual) {
        super(actual, FluentListAssert.class);
    }

    @Override
    public FluentListAssert isEmpty() {
        return this.hasSize(0);
    }

    @Override
    public FluentListAssert isNotEmpty() {
        return this.hasSize().notEqualTo(0);
    }

    @Override
    public FluentListAssert hasSize(int expectedSize) {
        int actualSize = ((FluentList)this.actual).count();
        if (actualSize != expectedSize) {
            this.failWithMessage("Expected size: " + expectedSize + ". Actual size: " + actualSize + ".");
        }
        return this;
    }

    @Override
    public FluentListSizeBuilder hasSize() {
        return new FluentListSizeBuilder(((FluentList)this.actual).count(), this);
    }

    @Override
    public FluentListAssert hasText(String textToFind) {
        List actualTexts = this.requiresNonEmpty(((FluentList)this.actual).texts());
        if (actualTexts.stream().noneMatch(text -> text.contains(textToFind))) {
            this.failWithMessage("No selected elements contains text: " + textToFind + ". Actual texts found: " + String.valueOf(actualTexts));
        }
        return this;
    }

    @Override
    public FluentListAssert hasTextContaining(String textToFind) {
        List actualTexts = this.requiresNonEmpty(((FluentList)this.actual).texts());
        if (actualTexts.stream().noneMatch(text -> text.contains(textToFind))) {
            this.failWithMessage("No selected elements contains text: " + textToFind + ". Actual texts found: " + String.valueOf(actualTexts));
        }
        return this;
    }

    @Override
    public FluentListAssert hasTextMatching(String regexToBeMatched) {
        List actualTexts = this.requiresNonEmpty(((FluentList)this.actual).texts());
        if (actualTexts.stream().noneMatch(text -> text.matches(regexToBeMatched))) {
            this.failWithMessage("No selected elements contains text matching: " + regexToBeMatched + ". Actual texts found: " + String.valueOf(actualTexts));
        }
        return this;
    }

    @Override
    public FluentListAssert hasNotText(String textToFind) {
        List actualTexts = this.requiresNonEmpty(((FluentList)this.actual).texts());
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            this.failWithMessage("At least one selected elements contains text: " + textToFind + ". Actual texts found: " + String.valueOf(actualTexts));
        }
        return this;
    }

    @Override
    public FluentListAssert hasNotTextContaining(String textToFind) {
        List actualTexts = this.requiresNonEmpty(((FluentList)this.actual).texts());
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            this.failWithMessage("At least one selected elements contains text: " + textToFind + ". Actual texts found: " + String.valueOf(actualTexts));
        }
        return this;
    }

    @Override
    public FluentListAssert hasId(String idToFind) {
        List actualIds = this.requiresNonEmpty(((FluentList)this.actual).ids());
        if (!actualIds.contains(idToFind)) {
            this.failWithMessage("No selected elements have id: " + idToFind + ". Actual ids found : " + String.valueOf(actualIds));
        }
        return this;
    }

    @Override
    public FluentListAssert hasClass(String classToFind) {
        return this.validateHasClasses("No selected elements have class: ", classToFind);
    }

    @Override
    public FluentListAssert hasClasses(String ... classesToFind) {
        return this.validateHasClasses("No selected element have classes: ", classesToFind);
    }

    @Override
    public FluentListAssert hasNotClass(String htmlClass) {
        this.notHasClasses("At least one selected element has class: ", htmlClass);
        return this;
    }

    @Override
    public FluentListAssert hasNotClasses(String ... htmlClasses) {
        this.notHasClasses("At least one selected element has classes: ", htmlClasses);
        return this;
    }

    @Override
    public FluentListAssert hasValue(String value) {
        List actualValues = this.requiresNonEmpty(((FluentList)this.actual).values());
        if (!actualValues.contains(value)) {
            this.failWithMessage("No selected elements have value: " + value + ". Actual values found : " + String.valueOf(actualValues));
        }
        return this;
    }

    @Override
    public FluentListAssert hasName(String name) {
        List actualNames = this.requiresNonEmpty(((FluentList)this.actual).names());
        if (!actualNames.contains(name)) {
            this.failWithMessage("No selected elements have name: " + name + ". Actual names found : " + String.valueOf(actualNames));
        }
        return this;
    }

    @Override
    public FluentListAssert hasTagName(String tagName) {
        List actualTags = this.requiresNonEmpty(((FluentList)this.actual).tagNames());
        if (!actualTags.contains(tagName)) {
            this.failWithMessage("No selected elements have tag: " + tagName + ". Actual tags found : " + String.valueOf(actualTags));
        }
        return this;
    }

    @Override
    public FluentListAssert hasDimension(Dimension dimension) {
        List actualDimensions = this.requiresNonEmpty(((FluentList)this.actual).dimensions());
        if (!actualDimensions.contains(dimension)) {
            this.failWithMessage("No selected elements have dimension: " + dimension.toString() + ". Actual dimensions found : " + actualDimensions.toString());
        }
        return this;
    }

    @Override
    public FluentListAssert hasAttributeValue(String attribute, String value) {
        List actualValues = this.requiresNonEmpty(((FluentList)this.actual).attributes(attribute));
        if (!actualValues.contains(value)) {
            this.failWithMessage("No selected elements have attribute " + attribute + " with value: " + value + ". Actual values found: " + String.valueOf(actualValues));
        }
        return this;
    }

    @Override
    public ListAssert<String> hasAttribute(String attribute) {
        List actualValues = this.requiresNonEmpty(((FluentList)this.actual).attributes(attribute));
        if (actualValues.stream().allMatch(Objects::isNull)) {
            this.failWithMessage("No selected element has attribute " + attribute);
        }
        return new ListAssert(actualValues);
    }

    @Override
    public FluentListAssert hasNotAttribute(String attribute) {
        List actualValues = this.requiresNonEmpty(((FluentList)this.actual).attributes(attribute));
        if (actualValues.stream().anyMatch(Objects::nonNull)) {
            this.failWithMessage("At least one selected element has attribute " + attribute);
        }
        return this;
    }

    private FluentListAssert validateHasClasses(String message, String ... classesToFind) {
        List elementsClasses = this.requiresNonEmpty(((FluentList)this.actual).attributes("class"));
        for (String elementClass : elementsClasses) {
            List<String> classesLst = this.getClasses(elementClass);
            if (!classesLst.containsAll(Arrays.asList(classesToFind))) continue;
            return this;
        }
        String classesFromElement = String.join((CharSequence)", ", elementsClasses);
        this.failWithMessage(message + String.join((CharSequence)", ", classesToFind) + ". Actual classes found : " + classesFromElement);
        return this;
    }

    private void notHasClasses(String message, String ... htmlClasses) {
        List elementsClasses = this.requiresNonEmpty(((FluentList)this.actual).attributes("class"));
        for (String elementClass : elementsClasses) {
            if (elementClass == null || !this.getClasses(elementClass).containsAll(Arrays.asList(htmlClasses))) continue;
            this.failWithMessage(message + String.valueOf(Arrays.asList(htmlClasses)));
        }
    }

    void failWithMessage(String errorMessage) {
        super.failWithMessage(errorMessage, new Object[0]);
    }

    private <T> List<T> requiresNonEmpty(List<T> elements) {
        if (elements.isEmpty()) {
            throw new AssertionError((Object)"List is empty. Please make sure you use correct selector.");
        }
        return elements;
    }
}

