/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.assertj.custom;

import io.fluentlenium.assertj.custom.FluentListAssert;

public class FluentListSizeBuilder {
    private static final String ACTUAL_SIZE = "Actual size: ";
    private final int actualSize;
    private final FluentListAssert listAssert;

    FluentListSizeBuilder(int size, FluentListAssert listAssert) {
        this.actualSize = size;
        this.listAssert = listAssert;
    }

    public FluentListAssert lessThan(int size) {
        if (this.actualSize >= size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not less than: " + size);
        }
        return this.listAssert;
    }

    public FluentListAssert lessThanOrEqualTo(int size) {
        if (this.actualSize > size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not less than or equal to: " + size);
        }
        return this.listAssert;
    }

    public FluentListAssert greaterThan(int size) {
        if (this.actualSize <= size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not greater than: " + size);
        }
        return this.listAssert;
    }

    public FluentListAssert greaterThanOrEqualTo(int size) {
        if (this.actualSize < size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not greater than or equal to: " + size);
        }
        return this.listAssert;
    }

    public FluentListAssert notEqualTo(int size) {
        if (this.actualSize == size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is equal to: " + size);
        }
        return this.listAssert;
    }

    public FluentListAssert equalTo(int size) {
        return this.listAssert.hasSize(size);
    }
}

