/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.assertj.custom;

import io.fluentlenium.assertj.custom.AbstractFluentAssert;
import io.fluentlenium.assertj.custom.ElementAttributeAssert;
import io.fluentlenium.assertj.custom.ElementStateAssert;
import io.fluentlenium.core.domain.FluentWebElement;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.StringAssert;
import org.openqa.selenium.Dimension;

public class FluentWebElementAssert
extends AbstractFluentAssert<FluentWebElementAssert, FluentWebElement>
implements ElementStateAssert,
ElementAttributeAssert {
    public FluentWebElementAssert(FluentWebElement actual) {
        super(actual, FluentWebElementAssert.class);
    }

    @Override
    public FluentWebElementAssert isEnabled() {
        this.isPresentAndIs(() -> !((FluentWebElement)this.actual).enabled(), "Element in assertion is present but not enabled");
        return this;
    }

    @Override
    public FluentWebElementAssert isNotEnabled() {
        this.isPresentAndIs(() -> ((FluentWebElement)this.actual).enabled(), "Element in assertion is present but enabled");
        return this;
    }

    @Override
    public FluentWebElementAssert isDisplayed() {
        this.isPresentAndIs(() -> !((FluentWebElement)this.actual).displayed(), "Element in assertion is present but not displayed");
        return this;
    }

    @Override
    public FluentWebElementAssert isNotDisplayed() {
        this.isPresentAndIs(() -> ((FluentWebElement)this.actual).displayed(), "Element in assertion is present but displayed");
        return this;
    }

    @Override
    public FluentWebElementAssert isSelected() {
        this.isPresentAndIs(() -> !((FluentWebElement)this.actual).selected(), "Element in assertion is present but not selected");
        return this;
    }

    @Override
    public FluentWebElementAssert isNotSelected() {
        this.isPresentAndIs(() -> ((FluentWebElement)this.actual).selected(), "Element in assertion is present but selected");
        return this;
    }

    @Override
    public FluentWebElementAssert isClickable() {
        this.isPresentAndIs(() -> !((FluentWebElement)this.actual).clickable(), "Element in assertion is present but not clickable");
        return this;
    }

    @Override
    public FluentWebElementAssert isNotClickable() {
        this.isPresentAndIs(() -> ((FluentWebElement)this.actual).clickable(), "Element in assertion is present but clickable");
        return this;
    }

    @Override
    public FluentWebElementAssert isPresent() {
        if (!((FluentWebElement)this.actual).present()) {
            this.failWithMessage("Element in assertion is not present", new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert isNotPresent() {
        if (((FluentWebElement)this.actual).present()) {
            this.failWithMessage("Element in assertion is present", new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasText(String textToFind) {
        String actualText = ((FluentWebElement)this.actual).text();
        if (!actualText.contains(textToFind)) {
            this.failWithMessage("The element does not contain the text: " + textToFind + ". Actual text found : " + actualText, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasTextContaining(String text) {
        String actualText = ((FluentWebElement)this.actual).text();
        if (!actualText.contains(text)) {
            this.failWithMessage("The element does not contain the text: " + text + ". Actual text found : " + actualText, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasTextMatching(String regexToBeMatched) {
        String actualText = ((FluentWebElement)this.actual).text();
        if (!actualText.matches(regexToBeMatched)) {
            this.failWithMessage("The element does not match the regex: " + regexToBeMatched + ". Actual text found : " + actualText, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasNotText(String textToFind) {
        if (((FluentWebElement)this.actual).text().contains(textToFind)) {
            this.failWithMessage("The element contains the text: " + textToFind, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasNotTextContaining(String textToFind) {
        if (((FluentWebElement)this.actual).text().contains(textToFind)) {
            this.failWithMessage("The element contains the text: " + textToFind, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasId(String idToFind) {
        String actualId = ((FluentWebElement)this.actual).id();
        if (!actualId.equals(idToFind)) {
            this.failWithMessage("The element does not have the id: " + idToFind + ". Actual id found : " + actualId, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasClass(String classToFind) {
        String actualClasses = ((FluentWebElement)this.actual).attribute("class");
        if (!this.getClasses(actualClasses).contains(classToFind)) {
            this.failWithMessage("The element does not have the class: " + classToFind + ". Actual class found : " + actualClasses, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasNotClass(String htmlClass) {
        String actualClasses = ((FluentWebElement)this.actual).attribute("class");
        if (actualClasses != null && this.getClasses(actualClasses).contains(htmlClass)) {
            this.failWithMessage("The element has class: " + htmlClass, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasClasses(String ... classesToFind) {
        String actualClasses = ((FluentWebElement)this.actual).attribute("class");
        if (StringUtil.isNullOrEmpty((String)actualClasses)) {
            this.failWithMessage("The element has no class attribute.", new Object[0]);
        }
        if (!this.getClasses(actualClasses).containsAll(Arrays.asList(classesToFind))) {
            this.failWithMessage("The element does not have all classes: " + Arrays.toString(classesToFind) + ". Actual classes found : " + actualClasses, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasNotClasses(String ... classesToFind) {
        List<String> actualClassesAsList;
        String actualClasses = ((FluentWebElement)this.actual).attribute("class");
        if (actualClasses != null && (actualClassesAsList = this.getClasses(actualClasses)).containsAll(Arrays.asList(classesToFind))) {
            this.failWithMessage("The element has the classes: " + Arrays.toString(classesToFind) + ". Actual classes found : " + actualClasses, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasValue(String value) {
        String actualValue = ((FluentWebElement)this.actual).value();
        if (!actualValue.equals(value)) {
            this.failWithMessage("The element does not have the value: " + value + ". Actual value found : " + actualValue, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasName(String name) {
        String actualName = ((FluentWebElement)this.actual).name();
        if (!actualName.equals(name)) {
            this.failWithMessage("The element does not have the name: " + name + ". Actual name found : " + actualName, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasTagName(String tagName) {
        String actualTag = ((FluentWebElement)this.actual).tagName();
        if (!actualTag.equals(tagName)) {
            this.failWithMessage("The element does not have tag: " + tagName + ". Actual tag found : " + actualTag, new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasDimension(Dimension dimension) {
        Dimension actualSize = ((FluentWebElement)this.actual).size();
        if (!actualSize.equals((Object)dimension)) {
            this.failWithMessage("The element does not have the same size: " + dimension.toString() + ". Actual size found : " + actualSize.toString(), new Object[0]);
        }
        return this;
    }

    @Override
    public FluentWebElementAssert hasAttributeValue(String attribute, String value) {
        String actualValue = ((FluentWebElement)this.actual).attribute(attribute);
        if (actualValue == null) {
            this.failWithMessage("The element does not have attribute " + attribute, new Object[0]);
        }
        if (!actualValue.equals(value)) {
            this.failWithMessage("The " + attribute + " attribute does not have the value: " + value + ". Actual value : " + actualValue, new Object[0]);
        }
        return this;
    }

    @Override
    public AbstractStringAssert hasAttribute(String attribute) {
        String actualValue = ((FluentWebElement)this.actual).attribute(attribute);
        if (StringUtil.isNullOrEmpty((String)actualValue)) {
            this.failWithMessage("The element does not have attribute " + attribute, new Object[0]);
        }
        return new StringAssert(actualValue);
    }

    @Override
    public FluentWebElementAssert hasNotAttribute(String attribute) {
        if (!StringUtil.isNullOrEmpty((String)((FluentWebElement)this.actual).attribute(attribute))) {
            this.failWithMessage("The element has attribute " + attribute, new Object[0]);
        }
        return this;
    }

    private void isPresentAndIs(Supplier<Boolean> elementCondition, String message) {
        this.isPresent();
        if (elementCondition.get().booleanValue()) {
            this.failWithMessage(message, new Object[0]);
        }
    }
}

