/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.assertj.custom;

import io.fluentlenium.assertj.custom.PageStateAssert;
import io.fluentlenium.core.FluentPage;
import io.fluentlenium.core.domain.FluentList;
import io.fluentlenium.core.domain.FluentWebElement;
import org.assertj.core.api.AbstractAssert;
import org.openqa.selenium.By;

public class PageAssert
extends AbstractAssert<PageAssert, FluentPage>
implements PageStateAssert {
    public PageAssert(FluentPage actual) {
        super((Object)actual, PageAssert.class);
    }

    @Override
    public PageAssert hasElement(FluentWebElement element) {
        if (!element.present()) {
            this.failWithMessage("Element " + element.toString() + " is not present on current page", new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasElements(FluentList<? extends FluentWebElement> fluentList) {
        if (fluentList.isEmpty()) {
            this.failWithMessage("No element selected by '" + fluentList.toString() + "' is present on the page.", new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasElementDisplayed(FluentWebElement element) {
        if (!element.displayed()) {
            this.failWithMessage("Element " + element.toString() + " is not displayed on current page", new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasTitle(String title) {
        try {
            String pageTitle = ((FluentPage)this.actual).getDriver().getTitle();
            if (!pageTitle.equals(title)) {
                this.failWithMessage("Current page title is " + pageTitle + ". Expected " + title, new Object[0]);
            }
        }
        catch (NullPointerException e) {
            this.failWithMessage("Current page has no title", new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasUrl(String url) {
        String pageUrl = ((FluentPage)this.actual).getDriver().getCurrentUrl();
        if (!pageUrl.equals(url)) {
            this.failWithMessage("Current page url is " + pageUrl + ". Expected " + url, new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasPageSourceContaining(String value) {
        String pageSource = ((FluentPage)this.actual).getDriver().getPageSource();
        if (!pageSource.contains(value)) {
            this.failWithMessage("Current page source does not contain: " + value, new Object[0]);
        }
        return this;
    }

    @Override
    public PageAssert hasExpectedUrl() {
        String url = ((FluentPage)this.actual).getUrl();
        if (url == null) {
            this.failWithMessage("Page has not defined @PageUrl", new Object[0]);
        }
        ((FluentPage)this.actual).isAtUsingUrl(url);
        return this;
    }

    @Override
    public PageAssert hasExpectedElements() {
        By by = ((FluentPage)this.actual).getClassAnnotations().buildBy();
        if (by == null) {
            this.failWithMessage("Page has not defined @FindBy class level annotation", new Object[0]);
        }
        ((FluentPage)this.actual).isAtUsingSelector(by);
        return this;
    }

    @Override
    @Deprecated
    public PageAssert isAt() {
        ((FluentPage)this.actual).isAt();
        return this;
    }
}

