/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.BaseConfiguration;
import io.fluentlenium.configuration.Configuration;
import io.fluentlenium.configuration.ConfigurationFactory;
import io.fluentlenium.configuration.ConfigurationMutator;
import io.fluentlenium.configuration.ConfigurationProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;

public class ComposedConfiguration
implements Configuration {
    private final ConfigurationProperties[] configurations;
    private final ConfigurationMutator writableConfiguration;

    public ComposedConfiguration(ConfigurationMutator writableConfiguration, ConfigurationProperties ... configurations) {
        this.writableConfiguration = writableConfiguration;
        this.configurations = configurations;
        if (writableConfiguration instanceof BaseConfiguration) {
            ((BaseConfiguration)((Object)writableConfiguration)).setGlobalConfiguration(this);
        }
    }

    List<ConfigurationProperties> getConfigurations() {
        return Arrays.asList(this.configurations);
    }

    ConfigurationMutator getWritableConfiguration() {
        return this.writableConfiguration;
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        return this.getConfig(ConfigurationProperties::getConfigurationFactory);
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        return this.getConfig(ConfigurationProperties::getConfigurationDefaults);
    }

    @Override
    public String getWebDriver() {
        return this.getConfig(ConfigurationProperties::getWebDriver);
    }

    @Override
    public String getRemoteUrl() {
        return this.getConfig(ConfigurationProperties::getRemoteUrl);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.getConfig(ConfigurationProperties::getCapabilities);
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        return this.getConfig(ConfigurationProperties::getDriverLifecycle);
    }

    @Override
    public Long getBrowserTimeout() {
        return this.getConfig(ConfigurationProperties::getBrowserTimeout);
    }

    @Override
    public Integer getBrowserTimeoutRetries() {
        return this.getConfig(ConfigurationProperties::getBrowserTimeoutRetries);
    }

    @Override
    public Boolean getDeleteCookies() {
        return this.getConfig(ConfigurationProperties::getDeleteCookies);
    }

    @Override
    public String getBaseUrl() {
        return this.getConfig(ConfigurationProperties::getBaseUrl);
    }

    @Override
    public Long getPageLoadTimeout() {
        return this.getConfig(ConfigurationProperties::getPageLoadTimeout);
    }

    @Override
    public Long getImplicitlyWait() {
        return this.getConfig(ConfigurationProperties::getImplicitlyWait);
    }

    @Override
    public Long getScriptTimeout() {
        return this.getConfig(ConfigurationProperties::getScriptTimeout);
    }

    @Override
    public Long getAwaitAtMost() {
        return this.getConfig(ConfigurationProperties::getAwaitAtMost);
    }

    @Override
    public Long getAwaitPollingEvery() {
        return this.getConfig(ConfigurationProperties::getAwaitPollingEvery);
    }

    @Override
    public Boolean getEventsEnabled() {
        return this.getConfig(ConfigurationProperties::getEventsEnabled);
    }

    @Override
    public String getScreenshotPath() {
        return this.getConfig(ConfigurationProperties::getScreenshotPath);
    }

    @Override
    public String getHtmlDumpPath() {
        return this.getConfig(ConfigurationProperties::getHtmlDumpPath);
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        return this.getConfig(ConfigurationProperties::getScreenshotMode);
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        return this.getConfig(ConfigurationProperties::getHtmlDumpMode);
    }

    @Override
    public String getCustomProperty(String propertyName) {
        return this.getConfig(configuration -> configuration.getCustomProperty(propertyName));
    }

    private <T> T getConfig(Function<ConfigurationProperties, T> configProvider) {
        return Arrays.stream(this.configurations).map(configProvider).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void setConfigurationFactory(Class<? extends ConfigurationFactory> configurationFactory) {
        this.getWritableConfiguration().setConfigurationFactory(configurationFactory);
    }

    @Override
    public void setDeleteCookies(Boolean deleteCookies) {
        this.getWritableConfiguration().setDeleteCookies(deleteCookies);
    }

    @Override
    public void setCustomProperty(String key, String value) {
        this.getWritableConfiguration().setCustomProperty(key, value);
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.getWritableConfiguration().setBaseUrl(baseUrl);
    }

    @Override
    public void setWebDriver(String webDriver) {
        this.getWritableConfiguration().setWebDriver(webDriver);
    }

    @Override
    public void setPageLoadTimeout(Long pageLoadTimeout) {
        this.getWritableConfiguration().setPageLoadTimeout(pageLoadTimeout);
    }

    @Override
    public void setHtmlDumpMode(ConfigurationProperties.TriggerMode htmlDumpMode) {
        this.getWritableConfiguration().setHtmlDumpMode(htmlDumpMode);
    }

    @Override
    public void setScreenshotPath(String screenshotPath) {
        this.getWritableConfiguration().setScreenshotPath(screenshotPath);
    }

    @Override
    public void setBrowserTimeoutRetries(Integer retriesNumber) {
        this.getWritableConfiguration().setBrowserTimeoutRetries(retriesNumber);
    }

    @Override
    public void setRemoteUrl(String remoteUrl) {
        this.getWritableConfiguration().setRemoteUrl(remoteUrl);
    }

    @Override
    public void setImplicitlyWait(Long implicitlyWait) {
        this.getWritableConfiguration().setImplicitlyWait(implicitlyWait);
    }

    @Override
    public void setDriverLifecycle(ConfigurationProperties.DriverLifecycle driverLifecycle) {
        this.getWritableConfiguration().setDriverLifecycle(driverLifecycle);
    }

    @Override
    public void setAwaitPollingEvery(Long awaitPollingEvery) {
        this.getWritableConfiguration().setAwaitPollingEvery(awaitPollingEvery);
    }

    @Override
    public void setCapabilities(Capabilities capabilities) {
        this.getWritableConfiguration().setCapabilities(capabilities);
    }

    @Override
    public void setScreenshotMode(ConfigurationProperties.TriggerMode screenshotMode) {
        this.getWritableConfiguration().setScreenshotMode(screenshotMode);
    }

    @Override
    public void setHtmlDumpPath(String htmlDumpPath) {
        this.getWritableConfiguration().setHtmlDumpPath(htmlDumpPath);
    }

    @Override
    public void setAwaitAtMost(Long awaitAtMost) {
        this.getWritableConfiguration().setAwaitAtMost(awaitAtMost);
    }

    @Override
    public void setBrowserTimeout(Long timeout) {
        this.getWritableConfiguration().setBrowserTimeout(timeout);
    }

    @Override
    public void setScriptTimeout(Long scriptTimeout) {
        this.getWritableConfiguration().setScriptTimeout(scriptTimeout);
    }

    @Override
    public void setEventsEnabled(Boolean eventsEnabled) {
        this.getWritableConfiguration().setEventsEnabled(eventsEnabled);
    }
}

