/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.fluentlenium.configuration.Configuration;
import io.fluentlenium.configuration.ConfigurationDefaults;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationFactory;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.DefaultConfigurationFactory;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public final class ConfigurationFactoryProvider {
    private static final ConfigurationFactory BOOTSTRAP_FACTORY = new DefaultConfigurationFactory();

    private ConfigurationFactoryProvider() {
    }

    public static ConfigurationFactory getConfigurationFactory(Class<?> container) {
        Configuration configuration = BOOTSTRAP_FACTORY.newConfiguration(container, new ConfigurationDefaults());
        Class<? extends ConfigurationFactory> configurationFactoryClass = configuration.getConfigurationFactory();
        if (configurationFactoryClass != null) {
            try {
                return ReflectionUtils.newInstance(configurationFactoryClass, new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("Can't initialize ConfigurationFactory " + configurationFactoryClass.getName(), e);
            }
        }
        return BOOTSTRAP_FACTORY;
    }

    public static Configuration newConfiguration(Class<?> container) {
        ConfigurationFactory configurationFactory = ConfigurationFactoryProvider.getConfigurationFactory(container);
        Configuration configuration = configurationFactory.newConfiguration(container, new ConfigurationDefaults());
        if (configuration.getConfigurationDefaults() != null && configuration.getConfigurationDefaults() != ConfigurationDefaults.class) {
            ConfigurationProperties configurationDefaults;
            try {
                configurationDefaults = ReflectionUtils.newInstance(configuration.getConfigurationDefaults(), new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("Can't initialize ConfigurationDefaults:" + String.valueOf(configuration.getConfigurationDefaults()), e);
            }
            configuration = configurationFactory.newConfiguration(container, configurationDefaults);
        }
        return configuration;
    }
}

