/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.configuration;

import io.appium.java_client.safari.options.SafariOptions;
import io.fluentlenium.configuration.ConfigurationException;
import io.fluentlenium.configuration.ConfigurationProperties;
import io.fluentlenium.configuration.DefaultFactory;
import io.fluentlenium.configuration.FactoryPriority;
import io.fluentlenium.configuration.ReflectiveWebDriverFactory;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DefaultWebDriverFactories {

    @DefaultFactory
    public static class RemoteWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public RemoteWebDriverFactory() {
            super("remote", RemoteWebDriver.class, new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            String remoteUrl;
            URL url = null;
            if (configuration != null && (remoteUrl = configuration.getRemoteUrl()) != null) {
                try {
                    url = new URL(remoteUrl);
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("remoteUrl configuration property is not a valid URL.", e);
                }
            }
            return this.newRemoteWebDriver(url, args.length > 0 ? args[0] : new DesiredCapabilities());
        }

        protected WebDriver newRemoteWebDriver(Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            WebDriver webDriver = (WebDriver)ReflectionUtils.getConstructor(this.webDriverClass, URL.class, Capabilities.class).newInstance(args);
            return new Augmenter().augment(webDriver);
        }
    }

    @FactoryPriority(value=4)
    @DefaultFactory
    public static class HtmlUnitWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public HtmlUnitWebDriverFactory() {
            super("htmlunit", "org.openqa.selenium.htmlunit.HtmlUnitDriver", new Object[0]);
        }

        @Override
        protected DesiredCapabilities newDefaultCapabilities() {
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
            desiredCapabilities.setJavascriptEnabled(true);
            desiredCapabilities.setBrowserName(Browser.HTMLUNIT.browserName());
            return desiredCapabilities;
        }
    }

    @FactoryPriority(value=16)
    @DefaultFactory
    public static class SafariWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public SafariWebDriverFactory() {
            super("safari", "org.openqa.selenium.safari.SafariDriver", new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            Capabilities oCaps = (Capabilities)args[0];
            SafariOptions options = new SafariOptions(oCaps);
            return super.newInstance(webDriverClass, configuration, options);
        }
    }

    @FactoryPriority(value=31)
    @DefaultFactory
    public static class EdgeWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public EdgeWebDriverFactory() {
            super("edge", "org.openqa.selenium.edge.EdgeDriver", new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            Capabilities oCaps = (Capabilities)args[0];
            EdgeOptions options = new EdgeOptions().merge(oCaps);
            return super.newInstance(webDriverClass, configuration, options);
        }
    }

    @FactoryPriority(value=32)
    @DefaultFactory
    public static class InternetExplorerWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public InternetExplorerWebDriverFactory() {
            super("ie", "org.openqa.selenium.ie.InternetExplorerDriver", new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            Capabilities oCaps = (Capabilities)args[0];
            InternetExplorerOptions options = new InternetExplorerOptions(oCaps);
            return super.newInstance(webDriverClass, configuration, options);
        }
    }

    @FactoryPriority(value=64)
    @DefaultFactory
    public static class ChromeWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public ChromeWebDriverFactory() {
            super("chrome", "org.openqa.selenium.chrome.ChromeDriver", new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            Capabilities oCaps = (Capabilities)args[0];
            ChromeOptions chromeOptions = new ChromeOptions();
            chromeOptions = chromeOptions.merge(oCaps);
            return super.newInstance(webDriverClass, configuration, chromeOptions);
        }
    }

    @FactoryPriority(value=128)
    @DefaultFactory
    public static class FirefoxWebDriverFactory
    extends ReflectiveWebDriverFactory {
        public FirefoxWebDriverFactory() {
            super("firefox", "org.openqa.selenium.firefox.FirefoxDriver", new Object[0]);
        }

        @Override
        protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            Capabilities oCaps = (Capabilities)args[0];
            FirefoxOptions options = new FirefoxOptions(oCaps);
            return super.newInstance(webDriverClass, configuration, options);
        }
    }
}

