/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core;

import io.fluentlenium.configuration.Configuration;
import io.fluentlenium.core.ScreenshotNotCreatedException;
import io.fluentlenium.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentDriverScreenshotPersister {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentDriverScreenshotPersister.class);
    private final Configuration configuration;
    private final WebDriver driver;

    public FluentDriverScreenshotPersister(Configuration configuration, WebDriver driver) {
        this.configuration = Objects.requireNonNull(configuration);
        this.driver = driver;
    }

    public File persistScreenshot(String fileName) {
        try {
            File destFile = this.configuration.getScreenshotPath() == null ? new File(fileName) : Paths.get(this.configuration.getScreenshotPath(), fileName).toFile();
            FileUtils.writeByteArrayToFile((File)destFile, (byte[])this.prepareScreenshot());
            LOGGER.info("Created screenshot at: " + destFile.getAbsolutePath());
            return destFile;
        }
        catch (IOException e) {
            throw new ScreenshotNotCreatedException("Error when taking the screenshot", e);
        }
    }

    private byte[] prepareScreenshot() {
        byte[] screenshot;
        try {
            screenshot = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
        }
        catch (UnhandledAlertException uae) {
            screenshot = new ImageUtils(this.driver).handleAlertAndTakeScreenshot();
        }
        return screenshot;
    }
}

