/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.conditions;

import io.fluentlenium.core.conditions.AbstractIntegerConditions;
import io.fluentlenium.core.conditions.Conditions;
import io.fluentlenium.core.conditions.DynamicIntegerConditionsImpl;
import io.fluentlenium.core.conditions.FluentListConditions;
import io.fluentlenium.core.conditions.ListConditionsElements;
import io.fluentlenium.core.conditions.RectangleConditions;
import io.fluentlenium.core.conditions.RectangleListConditionsImpl;
import io.fluentlenium.core.conditions.StringConditions;
import io.fluentlenium.core.conditions.StringListConditionsImpl;
import io.fluentlenium.core.domain.FluentList;
import io.fluentlenium.core.domain.FluentWebElement;
import java.util.List;
import java.util.function.Predicate;

public abstract class AbstractFluentListConditions
implements FluentListConditions,
ListConditionsElements {
    private final List<? extends FluentWebElement> elements;
    private boolean negation;

    protected AbstractFluentListConditions(List<? extends FluentWebElement> elements) {
        this.elements = elements;
    }

    @Override
    public boolean size(int size) {
        int elementsSize = this.getElementsSize();
        if (this.negation) {
            return elementsSize != size;
        }
        return elementsSize == size;
    }

    private int getElementsSize() {
        return this.elements instanceof FluentList ? ((FluentList)this.elements).count() : this.elements.size();
    }

    protected boolean isNegation() {
        return this.negation;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }

    protected List<? extends FluentWebElement> getElements() {
        return this.elements;
    }

    @Override
    public List<? extends FluentWebElement> getActualElements() {
        return this.elements;
    }

    @Override
    public AbstractIntegerConditions size() {
        return new DynamicIntegerConditionsImpl(() -> this.elements, this.negation);
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate) {
        return this.verify(predicate, false);
    }

    @Override
    public boolean present() {
        return this.verify((FluentWebElement input) -> input.conditions().present());
    }

    @Override
    public boolean clickable() {
        return this.verify((FluentWebElement input) -> input.conditions().clickable());
    }

    @Override
    public boolean stale() {
        return this.verify((FluentWebElement input) -> input.conditions().stale());
    }

    @Override
    public boolean displayed() {
        return this.verify((FluentWebElement input) -> input.conditions().displayed());
    }

    @Override
    public boolean enabled() {
        return this.verify((FluentWebElement input) -> input.conditions().enabled());
    }

    @Override
    public boolean selected() {
        return this.verify((FluentWebElement input) -> input.conditions().selected());
    }

    @Override
    public StringConditions attribute(String name) {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, input -> input.attribute(name), input -> input.conditions().attribute(name));
    }

    @Override
    public StringConditions id() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::id, input -> input.conditions().id());
    }

    @Override
    public StringConditions name() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::name, input -> input.conditions().name());
    }

    @Override
    public StringConditions tagName() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::tagName, input -> input.conditions().tagName());
    }

    @Override
    public StringConditions value() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::value, input -> input.conditions().value());
    }

    @Override
    public StringConditions text() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::text, input -> input.conditions().text());
    }

    @Override
    public StringConditions textContent() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::textContent, input -> input.conditions().textContent());
    }

    @Override
    public RectangleConditions rectangle() {
        return new RectangleListConditionsImpl(this);
    }

    @Override
    public boolean className(String className) {
        return this.verify((FluentWebElement input) -> input.conditions().className(className));
    }
}

