/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.css;

import io.fluentlenium.core.css.CssSupport;
import io.fluentlenium.core.script.JavascriptControl;
import io.fluentlenium.core.wait.AwaitControl;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.WebDriverException;

public class CssSupportImpl
implements CssSupport {
    private static final String INJECTOR_JS_PATH = "/io/fluentlenium/core/css/injector.js";
    private static final int MAX_SCRIPT_EXECUTION_RETRY_COUNT = 10;
    private static final long EXPLICIT_WAIT_PERIOD = 250L;
    private final JavascriptControl javascriptControl;
    private final AwaitControl awaitControl;

    public CssSupportImpl(JavascriptControl javascriptControl, AwaitControl awaitControl) {
        this.javascriptControl = Objects.requireNonNull(javascriptControl);
        this.awaitControl = Objects.requireNonNull(awaitControl);
    }

    @Override
    public void inject(String cssText) {
        cssText = cssText.replace("\r\n", "").replace("\n", "");
        cssText = StringEscapeUtils.escapeEcmaScript((String)cssText);
        this.executeScriptRetry("cssText = \"" + cssText + "\";\n" + this.getContentOf(INJECTOR_JS_PATH));
    }

    @Override
    public void injectResource(String cssResourceName) {
        this.inject(this.getContentOf(cssResourceName));
    }

    private String getContentOf(String resource) {
        String string;
        block8: {
            InputStream inputStream = this.getClass().getResourceAsStream(resource);
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private void executeScriptRetry(String script) {
        int retries = 0;
        while (true) {
            try {
                this.javascriptControl.executeScript(script, new Object[0]);
            }
            catch (WebDriverException e) {
                if (++retries >= 10) {
                    throw e;
                }
                this.awaitControl.await().explicitlyFor(250L);
                continue;
            }
            break;
        }
    }
}

