/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.events;

import com.google.common.collect.ImmutableList;
import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.components.DefaultComponentInstantiator;
import io.fluentlenium.core.events.AlertListener;
import io.fluentlenium.core.events.ElementListener;
import io.fluentlenium.core.events.EventAdapter;
import io.fluentlenium.core.events.EventListener;
import io.fluentlenium.core.events.EventsSupport;
import io.fluentlenium.core.events.ExceptionListener;
import io.fluentlenium.core.events.FindByListener;
import io.fluentlenium.core.events.GetScreenshotAsListener;
import io.fluentlenium.core.events.ListenerPriorityComparator;
import io.fluentlenium.core.events.NavigateAllListener;
import io.fluentlenium.core.events.NavigateListener;
import io.fluentlenium.core.events.NavigateToListener;
import io.fluentlenium.core.events.ScriptListener;
import io.fluentlenium.core.events.SwitchToWindowListener;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class EventsRegistry
implements WrapsDriver {
    private final EventFiringWebDriver eventDriver;
    private final EventsSupport support;
    private final DefaultComponentInstantiator instantiator;
    public final List<NavigateToListener> beforeNavigateTo = new ArrayList<NavigateToListener>();
    public final List<NavigateToListener> afterNavigateTo = new ArrayList<NavigateToListener>();
    public final List<NavigateListener> beforeNavigateBack = new ArrayList<NavigateListener>();
    public final List<NavigateListener> afterNavigateBack = new ArrayList<NavigateListener>();
    public final List<NavigateListener> beforeNavigateForward = new ArrayList<NavigateListener>();
    public final List<NavigateListener> afterNavigateForward = new ArrayList<NavigateListener>();
    public final List<NavigateAllListener> beforeNavigate = new ArrayList<NavigateAllListener>();
    public final List<NavigateAllListener> afterNavigate = new ArrayList<NavigateAllListener>();
    public final List<NavigateListener> beforeNavigateRefresh = new ArrayList<NavigateListener>();
    public final List<NavigateListener> afterNavigateRefresh = new ArrayList<NavigateListener>();
    public final List<FindByListener> beforeFindBy = new ArrayList<FindByListener>();
    public final List<FindByListener> afterFindBy = new ArrayList<FindByListener>();
    public final List<ElementListener> beforeClickOn = new ArrayList<ElementListener>();
    public final List<ElementListener> afterClickOn = new ArrayList<ElementListener>();
    public final List<ElementListener> beforeGetText = new ArrayList<ElementListener>();
    public final List<ElementListener> afterGetText = new ArrayList<ElementListener>();
    public final List<ElementListener> beforeChangeValueOf = new ArrayList<ElementListener>();
    public final List<ElementListener> afterChangeValueOf = new ArrayList<ElementListener>();
    public final List<ScriptListener> beforeScript = new ArrayList<ScriptListener>();
    public final List<ScriptListener> afterScript = new ArrayList<ScriptListener>();
    public final List<AlertListener> beforeAlertAccept = new ArrayList<AlertListener>();
    public final List<AlertListener> afterAlertAccept = new ArrayList<AlertListener>();
    public final List<AlertListener> beforeAlertDismiss = new ArrayList<AlertListener>();
    public final List<AlertListener> afterAlertDismiss = new ArrayList<AlertListener>();
    public final List<SwitchToWindowListener> beforeSwitchToWindow = new ArrayList<SwitchToWindowListener>();
    public final List<SwitchToWindowListener> afterSwitchToWindow = new ArrayList<SwitchToWindowListener>();
    public final List<GetScreenshotAsListener> beforeGetScreenshotAs = new ArrayList<GetScreenshotAsListener>();
    public final List<GetScreenshotAsListener> afterGetScreenshotAs = new ArrayList<GetScreenshotAsListener>();
    public final List<ExceptionListener> onException = new ArrayList<ExceptionListener>();
    public final List<List> eventLists = ImmutableList.of(this.beforeNavigateTo, this.afterNavigateTo, this.beforeNavigateBack, this.afterNavigateBack, this.beforeNavigateForward, this.afterNavigateForward, this.beforeNavigate, this.afterNavigate, this.beforeNavigateRefresh, this.afterNavigateRefresh, this.beforeFindBy, this.afterFindBy, (Object[])new List[]{this.beforeClickOn, this.afterClickOn, this.beforeChangeValueOf, this.afterChangeValueOf, this.beforeScript, this.afterScript, this.beforeGetText, this.afterGetText, this.beforeGetScreenshotAs, this.afterGetScreenshotAs, this.beforeSwitchToWindow, this.afterSwitchToWindow, this.onException});

    public EventsRegistry(FluentControl control) {
        this.eventDriver = (EventFiringWebDriver)control.getDriver();
        this.support = new EventsSupport(this);
        this.instantiator = new DefaultComponentInstantiator(control);
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(this.support, this.instantiator));
    }

    public EventsRegistry register(WebDriverEventListener eventListener) {
        this.eventDriver.register(eventListener);
        return this;
    }

    public EventsRegistry register(EventListener eventListener) {
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public EventsRegistry unregister(EventListener eventListener) {
        this.eventDriver.unregister((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public void close() {
        this.unregister(this.support);
    }

    public WebDriver getWrappedDriver() {
        return this.eventDriver.getWrappedDriver();
    }

    public EventsRegistry beforeNavigateTo(NavigateToListener listener) {
        this.beforeNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateTo(NavigateToListener listener) {
        this.afterNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateBack(NavigateListener listener) {
        this.beforeNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateBack(NavigateListener listener) {
        this.afterNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateForward(NavigateListener listener) {
        this.beforeNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateForward(NavigateListener listener) {
        this.afterNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigate(NavigateAllListener listener) {
        this.beforeNavigate.add(listener);
        return this;
    }

    public EventsRegistry afterNavigate(NavigateAllListener listener) {
        this.afterNavigate.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateRefresh(NavigateListener listener) {
        this.beforeNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateRefresh(NavigateListener listener) {
        this.afterNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry beforeFindBy(FindByListener listener) {
        this.beforeFindBy.add(listener);
        return this;
    }

    public EventsRegistry afterFindBy(FindByListener listener) {
        this.afterFindBy.add(listener);
        return this;
    }

    public EventsRegistry beforeClickOn(ElementListener listener) {
        this.beforeClickOn.add(listener);
        return this;
    }

    public EventsRegistry afterClickOn(ElementListener listener) {
        this.afterClickOn.add(listener);
        return this;
    }

    public EventsRegistry beforeGetText(ElementListener listener) {
        this.beforeGetText.add(listener);
        return this;
    }

    public EventsRegistry afterGetText(ElementListener listener) {
        this.afterGetText.add(listener);
        return this;
    }

    public EventsRegistry beforeChangeValueOf(ElementListener listener) {
        this.beforeChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry afterChangeValueOf(ElementListener listener) {
        this.afterChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry beforeScript(ScriptListener listener) {
        this.beforeScript.add(listener);
        return this;
    }

    public EventsRegistry afterScript(ScriptListener listener) {
        this.afterScript.add(listener);
        return this;
    }

    public EventsRegistry beforeAlertAccept(AlertListener listener) {
        this.beforeAlertAccept.add(listener);
        return this;
    }

    public EventsRegistry afterAlertAccept(AlertListener listener) {
        this.afterAlertAccept.add(listener);
        return this;
    }

    public EventsRegistry beforeAlertDismiss(AlertListener listener) {
        this.beforeAlertDismiss.add(listener);
        return this;
    }

    public EventsRegistry afterAlertDismiss(AlertListener listener) {
        this.afterAlertDismiss.add(listener);
        return this;
    }

    public EventsRegistry onException(ExceptionListener listener) {
        this.onException.add(listener);
        return this;
    }

    public EventsRegistry afterSwitchToWindow(SwitchToWindowListener listener) {
        this.afterSwitchToWindow.add(listener);
        return this;
    }

    public EventsRegistry beforeSwitchToWindow(SwitchToWindowListener listener) {
        this.beforeSwitchToWindow.add(listener);
        return this;
    }

    public EventsRegistry afterGetScreenshotAs(GetScreenshotAsListener listener) {
        this.afterGetScreenshotAs.add(listener);
        return this;
    }

    public EventsRegistry beforeGetScreenshotAs(GetScreenshotAsListener listener) {
        this.beforeGetScreenshotAs.add(listener);
        return this;
    }

    protected void sortListeners() {
        ListenerPriorityComparator comparator = new ListenerPriorityComparator();
        for (List eventList : this.eventLists) {
            eventList.sort(comparator);
        }
    }

    public void unregisterContainer(Object container) {
        for (List eventList : this.eventLists) {
            this.unregisterContainer(eventList, container);
        }
    }

    private void unregisterContainer(Iterable iterable, Object container) {
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof ContainerListener) || next != container) continue;
            iterator.remove();
        }
    }
}

