/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.wait;

import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.wait.BaseWaitConditions;
import io.fluentlenium.core.wait.FluentWait;
import java.util.function.Predicate;

public class FluentWaitWindowConditions
extends BaseWaitConditions {
    private final FluentWait wait;
    private final String windowName;

    protected FluentWaitWindowConditions(FluentWait wait, String windowName) {
        this.wait = wait;
        this.windowName = windowName;
    }

    public boolean displayed() {
        Predicate<FluentControl> displayed = fluent -> fluent.getDriver().getWindowHandles().contains(this.windowName);
        this.until(this.wait, displayed, String.format("Window %s should be displayed.", this.windowName));
        return true;
    }

    public boolean notDisplayed() {
        Predicate<FluentControl> notDisplayed = fluent -> !fluent.getDriver().getWindowHandles().contains(this.windowName);
        this.until(this.wait, notDisplayed, String.format("Window %s should not be displayed.", this.windowName));
        return true;
    }
}

