/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.accumulo.export;

import io.fluo.api.config.FluoConfiguration;
import io.fluo.api.observer.Observer;
import io.fluo.recipes.accumulo.export.AccumuloExport;
import io.fluo.recipes.accumulo.export.SharedBatchWriter;
import io.fluo.recipes.accumulo.export.TableInfo;
import io.fluo.recipes.export.Exporter;
import io.fluo.recipes.export.SequencedExport;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.accumulo.core.data.Mutation;
import org.apache.commons.configuration.Configuration;

public class AccumuloExporter<K>
extends Exporter<K, AccumuloExport<K>> {
    private SharedBatchWriter sbw;

    public void init(String queueId, Observer.Context context) throws Exception {
        Configuration appConf = context.getAppConfiguration();
        String instanceName = appConf.getString("recipes.accumuloExporter." + queueId + ".instance");
        String zookeepers = appConf.getString("recipes.accumuloExporter." + queueId + ".zookeepers");
        String user = appConf.getString("recipes.accumuloExporter." + queueId + ".user");
        String password = appConf.getString("recipes.accumuloExporter." + queueId + ".password");
        String table = appConf.getString("recipes.accumuloExporter." + queueId + ".table");
        this.sbw = SharedBatchWriter.getInstance(instanceName, zookeepers, user, password, table);
    }

    public static void setExportTableInfo(FluoConfiguration fconf, String queueId, TableInfo ti) {
        Configuration appConf = fconf.getAppConfiguration();
        appConf.setProperty("recipes.accumuloExporter." + queueId + ".instance", (Object)ti.instanceName);
        appConf.setProperty("recipes.accumuloExporter." + queueId + ".zookeepers", (Object)ti.zookeepers);
        appConf.setProperty("recipes.accumuloExporter." + queueId + ".user", (Object)ti.user);
        appConf.setProperty("recipes.accumuloExporter." + queueId + ".password", (Object)ti.password);
        appConf.setProperty("recipes.accumuloExporter." + queueId + ".table", (Object)ti.table);
    }

    protected void processExports(Iterator<SequencedExport<K, AccumuloExport<K>>> exports) {
        ArrayList<Mutation> buffer = new ArrayList<Mutation>();
        while (exports.hasNext()) {
            SequencedExport<K, AccumuloExport<K>> export = exports.next();
            buffer.addAll(((AccumuloExport)export.getValue()).toMutations(export.getKey(), export.getSequence()));
        }
        if (buffer.size() > 0) {
            this.sbw.write(buffer);
        }
    }
}

