/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.accumulo.export;

import com.google.common.base.Preconditions;
import io.fluo.api.data.Bytes;
import io.fluo.api.data.Column;
import io.fluo.api.data.RowColumn;
import io.fluo.recipes.accumulo.export.AccumuloExport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.data.Mutation;

public abstract class DifferenceExport<K, V>
implements AccumuloExport<K> {
    private Optional<V> oldVal;
    private Optional<V> newVal;

    public DifferenceExport() {
    }

    public DifferenceExport(Optional<V> oldVal, Optional<V> newVal) {
        Objects.requireNonNull(oldVal);
        Objects.requireNonNull(newVal);
        Preconditions.checkArgument((oldVal.isPresent() || newVal.isPresent() ? 1 : 0) != 0, (Object)"At least one value must be set");
        this.oldVal = oldVal;
        this.newVal = newVal;
    }

    protected abstract Map<RowColumn, Bytes> generateData(K var1, Optional<V> var2);

    @Override
    public Collection<Mutation> toMutations(K key, long seq) {
        RowColumn rc;
        Map<RowColumn, Bytes> oldData = this.generateData(key, this.oldVal);
        Map<RowColumn, Bytes> newData = this.generateData(key, this.newVal);
        HashMap<Bytes, Mutation> mutationMap = new HashMap<Bytes, Mutation>();
        for (Map.Entry<RowColumn, Bytes> entry : oldData.entrySet()) {
            rc = entry.getKey();
            if (newData.containsKey(rc)) continue;
            Mutation m = mutationMap.computeIfAbsent(rc.getRow(), r -> new Mutation(r.toArray()));
            m.putDelete(rc.getColumn().getFamily().toArray(), rc.getColumn().getQualifier().toArray(), seq);
        }
        for (Map.Entry<RowColumn, Bytes> entry : newData.entrySet()) {
            rc = entry.getKey();
            Column col = rc.getColumn();
            Bytes newVal = entry.getValue();
            Bytes oldVal = oldData.get(rc);
            if (oldVal != null && oldVal.equals((Object)newVal)) continue;
            Mutation m = mutationMap.computeIfAbsent(rc.getRow(), r -> new Mutation(r.toArray()));
            m.put(col.getFamily().toArray(), col.getQualifier().toArray(), seq, newVal.toArray());
        }
        return mutationMap.values();
    }
}

