/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.accumulo.export;

import io.fluo.api.data.Bytes;
import io.fluo.api.data.Column;
import io.fluo.recipes.accumulo.export.AccumuloExport;
import io.fluo.recipes.transaction.LogEntry;
import io.fluo.recipes.transaction.TxLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;

public class ReplicationExport<K>
implements AccumuloExport<K> {
    private TxLog txLog;

    public ReplicationExport() {
    }

    public ReplicationExport(TxLog txLog) {
        Objects.requireNonNull(txLog);
        this.txLog = txLog;
    }

    public static Predicate<LogEntry> getFilter() {
        return le -> le.getOp().equals((Object)LogEntry.Operation.DELETE) || le.getOp().equals((Object)LogEntry.Operation.SET);
    }

    @Override
    public Collection<Mutation> toMutations(K key, long seq) {
        HashMap<Bytes, Mutation> mutationMap = new HashMap<Bytes, Mutation>();
        for (LogEntry le : this.txLog.getLogEntries()) {
            LogEntry.Operation op = le.getOp();
            Column col = le.getColumn();
            byte[] cf = col.getFamily().toArray();
            byte[] cq = col.getQualifier().toArray();
            byte[] cv = col.getVisibility().toArray();
            if (!op.equals((Object)LogEntry.Operation.DELETE) && !op.equals((Object)LogEntry.Operation.SET)) continue;
            Mutation m = mutationMap.computeIfAbsent(le.getRow(), k -> new Mutation(k.toArray()));
            if (op.equals((Object)LogEntry.Operation.DELETE)) {
                if (col.isVisibilitySet()) {
                    m.putDelete(cf, cq, new ColumnVisibility(cv), seq);
                    continue;
                }
                m.putDelete(cf, cq, seq);
                continue;
            }
            if (col.isVisibilitySet()) {
                m.put(cf, cq, new ColumnVisibility(cv), seq, le.getValue().toArray());
                continue;
            }
            m.put(cf, cq, seq, le.getValue().toArray());
        }
        return mutationMap.values();
    }
}

