/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.accumulo.ops;

import io.fluo.api.client.FluoClient;
import io.fluo.api.client.FluoFactory;
import io.fluo.api.config.FluoConfiguration;
import io.fluo.api.data.Bytes;
import io.fluo.recipes.common.Pirtos;
import io.fluo.recipes.common.RowRange;
import io.fluo.recipes.common.TransientRegistry;
import java.util.List;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperations {
    private static final String RGB_CLASS = "org.apache.accumulo.server.master.balancer.RegexGroupBalancer";
    private static final String RGB_PATTERN_PROP = "table.custom.balancer.group.regex.pattern";
    private static final String RGB_DEFAULT_PROP = "table.custom.balancer.group.regex.default";
    private static final String TABLE_BALANCER_PROP = "table.balancer";
    private static final Logger logger = LoggerFactory.getLogger(TableOperations.class);

    private static Connector getConnector(FluoConfiguration fluoConfig) throws Exception {
        ZooKeeperInstance zki = new ZooKeeperInstance((Configuration)new ClientConfiguration(new Configuration[0]).withInstance(fluoConfig.getAccumuloInstance()).withZkHosts(fluoConfig.getAccumuloZookeepers()));
        Connector conn = zki.getConnector(fluoConfig.getAccumuloUser(), (AuthenticationToken)new PasswordToken((CharSequence)fluoConfig.getAccumuloPassword()));
        return conn;
    }

    public static void optimizeTable(FluoConfiguration fluoConfig, Pirtos pirtos) throws Exception {
        Connector conn = TableOperations.getConnector(fluoConfig);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (Bytes split : pirtos.getSplits()) {
            splits.add(new Text(split.toArray()));
        }
        String table = fluoConfig.getAccumuloTable();
        conn.tableOperations().addSplits(table, splits);
        if (pirtos.getTabletGroupingRegex() != null && !pirtos.getTabletGroupingRegex().isEmpty()) {
            try {
                conn.tableOperations().setProperty(table, RGB_PATTERN_PROP, pirtos.getTabletGroupingRegex());
                conn.tableOperations().setProperty(table, RGB_DEFAULT_PROP, "none");
                conn.tableOperations().setProperty(table, TABLE_BALANCER_PROP, RGB_CLASS);
            }
            catch (AccumuloException e) {
                logger.warn("Unable to setup regex balancer (this is expected to fail in Accumulo 1.6.X) : " + e.getMessage());
                logger.debug("Unable to setup regex balancer (this is expected to fail in Accumulo 1.6.X)", (Throwable)e);
            }
        }
    }

    public static void compactTransient(FluoConfiguration fluoConfig) throws Exception {
        Connector conn = TableOperations.getConnector(fluoConfig);
        try (FluoClient client = FluoFactory.newClient((Configuration)fluoConfig);){
            Configuration appConfig = client.getAppConfiguration();
            TransientRegistry transientRegistry = new TransientRegistry(appConfig);
            List ranges = transientRegistry.getTransientRanges();
            for (RowRange r : ranges) {
                logger.debug("Compacting {} {}", (Object)r.getStart(), (Object)r.getEnd());
                conn.tableOperations().compact(fluoConfig.getAccumuloTable(), new Text(r.getStart().toArray()), new Text(r.getEnd().toArray()), true, true);
            }
        }
    }
}

