/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.test;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.fluo.api.client.FluoClient;
import io.fluo.api.client.FluoFactory;
import io.fluo.api.client.Snapshot;
import io.fluo.api.config.FluoConfiguration;
import io.fluo.api.config.ScannerConfiguration;
import io.fluo.api.data.Bytes;
import io.fluo.api.data.Column;
import io.fluo.api.data.RowColumnValue;
import io.fluo.api.iterator.ColumnIterator;
import io.fluo.api.iterator.RowIterator;
import io.fluo.recipes.test.Hex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoITHelper {
    private static final Logger log = LoggerFactory.getLogger(FluoITHelper.class);

    public static void printRowColumnValues(Collection<RowColumnValue> rcvList) {
        System.out.println("== RDD start ==");
        rcvList.forEach(rcv -> System.out.println("rc " + Hex.encNonAscii(rcv, " ")));
        System.out.println("== RDD end ==");
    }

    public static void printFluoTable(FluoConfiguration conf) {
        try (FluoClient client = FluoFactory.newClient((Configuration)conf);){
            FluoITHelper.printFluoTable(client);
        }
    }

    public static void printFluoTable(FluoClient client) {
        try (Snapshot s = client.newSnapshot();){
            RowIterator iter = s.get(new ScannerConfiguration());
            System.out.println("== fluo start ==");
            while (iter.hasNext()) {
                Map.Entry rowEntry = (Map.Entry)iter.next();
                ColumnIterator citer = (ColumnIterator)rowEntry.getValue();
                while (citer.hasNext()) {
                    Map.Entry colEntry = (Map.Entry)citer.next();
                    StringBuilder sb = new StringBuilder();
                    Hex.encNonAscii(sb, (Bytes)rowEntry.getKey());
                    sb.append(" ");
                    Hex.encNonAscii(sb, (Column)colEntry.getKey(), " ");
                    sb.append("\t");
                    Hex.encNonAscii(sb, (Bytes)colEntry.getValue());
                    System.out.println(sb.toString());
                }
            }
            System.out.println("=== fluo end ===");
        }
    }

    public static boolean verifyFluoTable(FluoConfiguration conf, Collection<RowColumnValue> expected) {
        try (FluoClient client = FluoFactory.newClient((Configuration)conf);){
            boolean bl = FluoITHelper.verifyFluoTable(client, expected);
            return bl;
        }
    }

    public static boolean verifyFluoTable(FluoClient client, Collection<RowColumnValue> expected) {
        expected = FluoITHelper.sort(expected);
        try (Snapshot s = client.newSnapshot();){
            RowIterator rowIter = s.get(new ScannerConfiguration());
            Iterator<RowColumnValue> rcvIter = expected.iterator();
            while (rowIter.hasNext()) {
                Map.Entry rowEntry = (Map.Entry)rowIter.next();
                ColumnIterator citer = (ColumnIterator)rowEntry.getValue();
                while (citer.hasNext() && rcvIter.hasNext()) {
                    Map.Entry colEntry = (Map.Entry)citer.next();
                    RowColumnValue rcv = rcvIter.next();
                    Column col = (Column)colEntry.getKey();
                    boolean retval = FluoITHelper.diff("fluo row", rcv.getRow(), (Bytes)rowEntry.getKey());
                    retval |= FluoITHelper.diff("fluo fam", rcv.getColumn().getFamily(), col.getFamily());
                    retval |= FluoITHelper.diff("fluo qual", rcv.getColumn().getQualifier(), col.getQualifier());
                    if (retval |= FluoITHelper.diff("fluo val", rcv.getValue(), (Bytes)colEntry.getValue())) {
                        log.error("Difference found - row {} cf {} cq {} val {}", new Object[]{rcv.getRow().toString(), rcv.getColumn().getFamily().toString(), rcv.getColumn().getQualifier().toString(), rcv.getValue().toString()});
                        boolean bl = false;
                        return bl;
                    }
                    log.debug("Verified {}", (Object)Hex.encNonAscii(rcv, " "));
                }
                if (!citer.hasNext()) continue;
                log.error("An column iterator still has more data");
                boolean bl = false;
                return bl;
            }
            if (rowIter.hasNext() || rcvIter.hasNext()) {
                log.error("An iterator still has more data");
                boolean bl = false;
                return bl;
            }
            log.debug("Actual data matched expected data");
            boolean bl = true;
            return bl;
        }
    }

    public static void printAccumuloTable(Connector conn, String accumuloTable) {
        Scanner scanner = null;
        try {
            scanner = conn.createScanner(accumuloTable, Authorizations.EMPTY);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(e);
        }
        Iterator iterator = scanner.iterator();
        System.out.println("== accumulo start ==");
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
        System.out.println("== accumulo end ==");
    }

    private static boolean diff(String dataType, String expected, String actual) {
        if (!expected.equals(actual)) {
            log.error("Difference found in {} - expected {} actual {}", new Object[]{dataType, expected, actual});
            return true;
        }
        return false;
    }

    private static boolean diff(String dataType, Bytes expected, Bytes actual) {
        if (!expected.equals((Object)actual)) {
            log.error("Difference found in {} - expected {} actual {}", new Object[]{dataType, Hex.encNonAscii(expected), Hex.encNonAscii(actual)});
            return true;
        }
        return false;
    }

    public static boolean verifyAccumuloTable(Connector conn, String accumuloTable, Collection<RowColumnValue> expected) {
        Scanner scanner;
        expected = FluoITHelper.sort(expected);
        try {
            scanner = conn.createScanner(accumuloTable, Authorizations.EMPTY);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(e);
        }
        Iterator scanIter = scanner.iterator();
        Iterator<RowColumnValue> rcvIter = expected.iterator();
        while (scanIter.hasNext() && rcvIter.hasNext()) {
            RowColumnValue rcv = rcvIter.next();
            Map.Entry kvEntry = (Map.Entry)scanIter.next();
            Key key = (Key)kvEntry.getKey();
            Column col = rcv.getColumn();
            boolean retval = FluoITHelper.diff("row", rcv.getRow().toString(), key.getRow().toString());
            retval |= FluoITHelper.diff("fam", col.getFamily().toString(), key.getColumnFamily().toString());
            retval |= FluoITHelper.diff("qual", col.getQualifier().toString(), key.getColumnQualifier().toString());
            if (retval |= FluoITHelper.diff("val", rcv.getValue().toString(), ((Value)kvEntry.getValue()).toString())) {
                log.error("Difference found - row {} cf {} cq {} val {}", new Object[]{rcv.getRow().toString(), col.getFamily().toString(), col.getQualifier().toString(), rcv.getValue().toString()});
                return false;
            }
            log.debug("Verified row {} cf {} cq {} val {}", new Object[]{rcv.getRow().toString(), col.getFamily().toString(), col.getQualifier().toString(), rcv.getValue().toString()});
        }
        if (scanIter.hasNext() || rcvIter.hasNext()) {
            log.error("An iterator still has more data");
            return false;
        }
        log.debug("Actual data matched expected data");
        return true;
    }

    public static boolean verifyRowColumnValues(Collection<RowColumnValue> expected, Collection<RowColumnValue> actual) {
        expected = FluoITHelper.sort(expected);
        actual = FluoITHelper.sort(actual);
        Iterator<RowColumnValue> expectIter = expected.iterator();
        Iterator<RowColumnValue> actualIter = actual.iterator();
        while (expectIter.hasNext() && actualIter.hasNext()) {
            RowColumnValue expRcv = expectIter.next();
            RowColumnValue actRcv = actualIter.next();
            boolean retval = FluoITHelper.diff("rcv row", expRcv.getRow(), actRcv.getRow());
            retval |= FluoITHelper.diff("rcv fam", expRcv.getColumn().getFamily(), actRcv.getColumn().getFamily());
            retval |= FluoITHelper.diff("rcv qual", expRcv.getColumn().getQualifier(), actRcv.getColumn().getQualifier());
            if (retval |= FluoITHelper.diff("rcv val", expRcv.getValue(), actRcv.getValue())) {
                log.error("Difference found in RowColumnValue lists - expected {} actual {}", (Object)expRcv, (Object)actRcv);
                return false;
            }
            log.debug("Verified row/col/val: {}", (Object)expRcv);
        }
        if (expectIter.hasNext() || actualIter.hasNext()) {
            log.error("A RowColumnValue list iterator still has more data");
            return false;
        }
        log.debug("Actual data matched expected data");
        return true;
    }

    private static List<RowColumnValue> sort(Collection<RowColumnValue> input) {
        ArrayList<RowColumnValue> copy = new ArrayList<RowColumnValue>(input);
        Collections.sort(copy);
        return copy;
    }

    public static List<RowColumnValue> parse(String ... data) {
        return FluoITHelper.parse(Splitter.on((char)'|'), data);
    }

    public static List<RowColumnValue> parse(Splitter splitter, String ... data) {
        ArrayList<RowColumnValue> ret = new ArrayList<RowColumnValue>();
        for (String line : data) {
            Iterable cols = splitter.split((CharSequence)line);
            if (Iterables.size((Iterable)cols) != 4) {
                throw new IllegalArgumentException("Bad input " + line);
            }
            Iterator iter = cols.iterator();
            RowColumnValue rcv = new RowColumnValue(Bytes.of((String)((String)iter.next())), new Column((String)iter.next(), (String)iter.next()), Bytes.of((String)((String)iter.next())));
            ret.add(rcv);
        }
        return ret;
    }
}

