/*
 * Decompiled with CFR 0.152.
 */
package io.fluo.recipes.test;

import io.fluo.api.data.Bytes;
import io.fluo.api.data.Column;
import io.fluo.api.data.RowColumn;
import io.fluo.api.data.RowColumnValue;
import java.io.ByteArrayOutputStream;

class Hex {
    Hex() {
    }

    public static void encNonAscii(StringBuilder sb, Bytes bytes) {
        for (int i = 0; i < bytes.length(); ++i) {
            byte b = bytes.byteAt(i);
            if (b >= 32 && b <= 126 && b != 92) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("\\x%02x", b & 0xFF));
        }
    }

    public static String encNonAscii(Bytes bytes) {
        StringBuilder sb = new StringBuilder();
        Hex.encNonAscii(sb, bytes);
        return sb.toString();
    }

    public static void encNonAscii(StringBuilder sb, Column c, String sep) {
        Hex.encNonAscii(sb, c.getFamily());
        sb.append(sep);
        Hex.encNonAscii(sb, c.getQualifier());
    }

    public static void encNonAscii(StringBuilder sb, RowColumn rc, String sep) {
        Hex.encNonAscii(sb, rc.getRow());
        sb.append(sep);
        Hex.encNonAscii(sb, rc.getColumn(), sep);
    }

    public static String encNonAscii(RowColumnValue rcv, String sep) {
        StringBuilder sb = new StringBuilder();
        Hex.encNonAscii(sb, rcv.getRow());
        sb.append(sep);
        Hex.encNonAscii(sb, rcv.getColumn(), sep);
        sb.append(sep);
        Hex.encNonAscii(sb, rcv.getValue());
        return sb.toString();
    }

    static byte[] decode(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            byte b;
            if (s.charAt(i) == '\\') {
                if (s.charAt(i + 1) != 'x') {
                    throw new IllegalArgumentException();
                }
                String num = "" + s.charAt(i + 2) + s.charAt(i + 3);
                b = (byte)(0xFF & Integer.parseInt(num, 16));
                i += 3;
            } else {
                char c = s.charAt(i);
                if (c < ' ' || c > '~') {
                    throw new IllegalArgumentException();
                }
                b = (byte)(0xFF & c);
            }
            baos.write(b);
        }
        return baos.toByteArray();
    }
}

