/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.NoOpAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class BeanParameterResolver
implements ParameterResolver<Object> {
    static final Class<? extends Annotation> autowiredClass = ReflectionUtils.classForName((String)"org.springframework.beans.factory.annotation.Autowired", NoOpAnnotation.class);
    private final Collection<Object> beans = ConcurrentHashMap.newKeySet();

    public Registration registerBean(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        this.beans.add(bean);
        return () -> this.beans.remove(bean.getClass());
    }

    public UnaryOperator<Object> resolve(Parameter p, Annotation methodAnnotation) {
        return v -> this.beans.stream().filter(b -> p.getType().isAssignableFrom(b.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("No qualifying bean of type '" + String.valueOf(p.getType()) + "' available"));
    }

    public boolean matches(Parameter parameter, Annotation methodAnnotation, Object value) {
        return ReflectionUtils.has(autowiredClass, (Parameter)parameter);
    }
}

