/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.ThrowingConsumer;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.Given;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public interface Then<R> {
    public Then<R> expectEvents(Object ... var1);

    default public <T> Then<R> expectEvent(Predicate<T> predicate) {
        return this.expectEvents(predicate);
    }

    public Then<R> expectOnlyEvents(Object ... var1);

    public Then<R> expectNoEventsLike(Object ... var1);

    default public Then<R> expectNoEvents() {
        return this.expectOnlyEvents(new Object[0]);
    }

    public Then<R> expectCommands(Object ... var1);

    default public <T> Then<R> expectCommand(Predicate<T> predicate) {
        return this.expectCommands(predicate);
    }

    public Then<R> expectOnlyCommands(Object ... var1);

    public Then<R> expectNoCommandsLike(Object ... var1);

    default public Then<R> expectNoCommands() {
        return this.expectOnlyCommands(new Object[0]);
    }

    public Then<R> expectQueries(Object ... var1);

    default public <T> Then<R> expectQuery(Predicate<T> predicate) {
        return this.expectQueries(predicate);
    }

    public Then<R> expectOnlyQueries(Object ... var1);

    public Then<R> expectNoQueriesLike(Object ... var1);

    default public Then<R> expectNoQueries() {
        return this.expectOnlyQueries(new Object[0]);
    }

    public Then<R> expectWebRequests(Object ... var1);

    default public Then<R> expectWebRequest(Predicate<WebRequest> predicate) {
        return this.expectWebRequests(predicate);
    }

    public Then<R> expectOnlyWebRequests(Object ... var1);

    public Then<R> expectNoWebRequestsLike(Object ... var1);

    default public Then<R> expectNoWebRequests() {
        return this.expectOnlyWebRequests(new Object[0]);
    }

    public Then<R> expectWebResponses(Object ... var1);

    default public Then<R> expectWebResponse(Predicate<WebResponse> predicate) {
        return this.expectWebResponses(predicate);
    }

    public Then<R> expectOnlyWebResponses(Object ... var1);

    public Then<R> expectNoWebResponsesLike(Object ... var1);

    default public Then<R> expectNoWebResponses() {
        return this.expectOnlyWebResponses(new Object[0]);
    }

    public Then<R> expectNewSchedules(Object ... var1);

    default public Then<R> expectNewSchedule(Predicate<Schedule> predicate) {
        return this.expectNewSchedules(predicate);
    }

    public Then<R> expectOnlyNewSchedules(Object ... var1);

    public Then<R> expectNoNewSchedulesLike(Object ... var1);

    default public Then<R> expectNoNewSchedules() {
        return this.expectOnlyNewSchedules(new Object[0]);
    }

    public Then<R> expectSchedules(Object ... var1);

    default public Then<R> expectSchedule(Predicate<Schedule> predicate) {
        return this.expectSchedules(predicate);
    }

    public Then<R> expectOnlySchedules(Object ... var1);

    public Then<R> expectNoSchedulesLike(Object ... var1);

    default public Then<R> expectNoSchedules() {
        return this.expectOnlySchedules(new Object[0]);
    }

    public Then<R> expectResult(Object var1);

    default public <R2 extends R> Then<R2> expectResult(@NonNull Class<? extends R2> resultClass) {
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return this.expectResult(r -> r instanceof Class ? r.equals(resultClass) : resultClass.isInstance(r), String.format("an instance of %s", resultClass.getSimpleName()));
    }

    default public <R2 extends R> Then<R2> expectResult(Predicate<R2> predicate) {
        return this.expectResult(predicate, "Predicate matcher");
    }

    default public <R2 extends R> Then<R2> verifyResult(ThrowingConsumer<R2> verifier) {
        return this.expectResult(r -> {
            try {
                verifier.accept(r);
                return true;
            }
            catch (Throwable e) {
                ClientUtils.runSilently(() -> {
                    throw e;
                });
                return false;
            }
        }, "Custom verifier");
    }

    public <R2 extends R> Then<R2> expectResult(Predicate<R2> var1, String var2);

    default public <M extends Message> Then<R> expectResultMessage(Predicate<M> messagePredicate) {
        return this.expectResultMessage(messagePredicate, "Predicate matcher");
    }

    public <M extends Message> Then<R> expectResultMessage(Predicate<M> var1, String var2);

    default public <M extends Message> Then<R> verifyResultMessage(ThrowingConsumer<M> verifier) {
        return this.expectResultMessage(r -> {
            try {
                verifier.accept(r);
                return true;
            }
            catch (Throwable e) {
                ClientUtils.runSilently(() -> {
                    throw e;
                });
                return false;
            }
        }, "Custom verifier");
    }

    default public Then<R> expectNonNullResult() {
        return this.expectResult(Objects::nonNull);
    }

    default public Then<R> expectNoResult() {
        return this.expectResult((Object)null);
    }

    public Then<R> expectNoResultLike(Object var1);

    public <T> Then<R> expectResultContaining(T ... var1);

    public <MR> Then<MR> mapResult(Function<? super R, ? extends MR> var1);

    public Then<R> expectExceptionalResult(Object var1);

    default public Then<R> expectExceptionalResult() {
        return this.expectExceptionalResult(Objects::nonNull);
    }

    default public Then<R> expectExceptionalResult(@NonNull Class<? extends Throwable> exceptionClass) {
        if (exceptionClass == null) {
            throw new NullPointerException("exceptionClass is marked non-null but is null");
        }
        return this.expectExceptionalResult(exceptionClass::isInstance, String.format("an instance of %s", exceptionClass.getSimpleName()));
    }

    default public <T extends Throwable> Then<R> expectExceptionalResult(Predicate<T> predicate) {
        return this.expectExceptionalResult(predicate, "Predicate matcher");
    }

    default public <T extends Throwable> Then<R> verifyExceptionalResult(ThrowingConsumer<T> verifier) {
        return this.expectExceptionalResult(r -> {
            try {
                verifier.accept(r);
                return true;
            }
            catch (Throwable e) {
                ClientUtils.runSilently(() -> {
                    throw e;
                });
                return false;
            }
        }, "Custom verifier");
    }

    public <T extends Throwable> Then<R> expectExceptionalResult(Predicate<T> var1, String var2);

    default public Then<R> expectSuccessfulResult() {
        return this.expectResult((R2 r) -> !(r instanceof Throwable));
    }

    default public <R2 extends R> Then<R2> expectResult() {
        return this.expectSuccessfulResult();
    }

    public Then<R> expectError(Object var1);

    default public <T extends Throwable> Then<R> expectError(Predicate<T> predicate) {
        return this.expectError(predicate, "Predicate matcher");
    }

    default public <T extends Throwable> Then<R> verifyError(ThrowingConsumer<T> verifier) {
        return this.expectError(e -> {
            try {
                verifier.accept(e);
                return true;
            }
            catch (Throwable ex) {
                ClientUtils.runSilently(() -> {
                    throw ex;
                });
                return false;
            }
        }, "Custom matcher");
    }

    default public Then<R> expectError() {
        return this.expectError(Objects::nonNull);
    }

    default public Then<R> expectError(@NonNull Class<? extends Throwable> errorClass) {
        if (errorClass == null) {
            throw new NullPointerException("errorClass is marked non-null but is null");
        }
        return this.expectError(errorClass::isInstance, String.format("an instance of %s", errorClass.getSimpleName()));
    }

    public <T extends Throwable> Then<R> expectError(Predicate<T> var1, String var2);

    public Then<R> expectNoErrors();

    public Then<R> expectMetrics(Object ... var1);

    default public <T> Then<R> expectMetric(Predicate<T> predicate) {
        return this.expectMetrics(predicate);
    }

    public Then<R> expectOnlyMetrics(Object ... var1);

    public Then<R> expectNoMetricsLike(Object ... var1);

    default public Then<R> expectNoMetrics() {
        return this.expectOnlyMetrics(new Object[0]);
    }

    public Then<R> expectThat(Consumer<FluxCapacitor> var1);

    public Then<R> expectTrue(Predicate<FluxCapacitor> var1);

    default public Then<R> expectFalse(Predicate<FluxCapacitor> check) {
        return this.expectTrue(check.negate());
    }

    public Given andThen();
}

