/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.MemoizingBiFunction;
import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.MemoizingSupplier;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.ThrowingRunnable;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.modeling.SearchParameters;
import io.fluxcapacitor.javaclient.persisting.search.Searchable;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClientUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);
    public static final Marker ignoreMarker = MarkerFactory.getMarker((String)"ignoreError");
    private static final BiFunction<Class<?>, Executable, Optional<LocalHandler>> localHandlerCache = ClientUtils.memoize((T target, U method) -> ReflectionUtils.getAnnotation((AnnotatedElement)method, LocalHandler.class).or(() -> Optional.ofNullable((LocalHandler)ReflectionUtils.getTypeAnnotation((Class)target, LocalHandler.class))).or(() -> ReflectionUtils.getPackageAnnotation((Package)target.getPackage(), LocalHandler.class)));
    private static final BiFunction<Class<?>, Executable, Optional<TrackSelf>> trackSelfCache = ClientUtils.memoize((T target, U method) -> ReflectionUtils.getAnnotation((AnnotatedElement)method, TrackSelf.class).or(() -> Optional.ofNullable((TrackSelf)ReflectionUtils.getTypeAnnotation((Class)target, TrackSelf.class))).or(() -> ReflectionUtils.getPackageAnnotation((Package)target.getPackage(), TrackSelf.class)));
    private static final Function<Class<?>, SearchParameters> searchParametersCache = ClientUtils.memoize((K type) -> ReflectionUtils.getAnnotationAs((Class)type, Searchable.class, SearchParameters.class).map(p -> p.getCollection() == null ? p.withCollection(type.getSimpleName()) : p).orElseGet(() -> new SearchParameters(true, type.getSimpleName(), null, null)));

    public static void waitForResults(Duration maxDuration, Collection<? extends Future<?>> futures) {
        Instant deadline = Instant.now().plus(maxDuration);
        for (Future<?> f : futures) {
            try {
                f.get(Math.max(0L, Duration.between(Instant.now(), deadline).toMillis()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Thread was interrupted before receiving all expected results", (Throwable)e);
                return;
            }
            catch (TimeoutException e) {
                log.warn("Timed out before having received all expected results", (Throwable)e);
                return;
            }
            catch (ExecutionException executionException) {
            }
        }
    }

    public static void tryRun(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            log.warn("Task {} failed", (Object)task, (Object)e);
        }
    }

    public static void runSilently(ThrowingRunnable runnable) {
        runnable.run();
    }

    public static boolean isSelfTracking(Class<?> target, Executable method) {
        return trackSelfCache.apply(target, method).isPresent();
    }

    public static Optional<TrackSelf> getTrackSelfAnnotation(Class<?> target, Executable method) {
        return trackSelfCache.apply(target, method);
    }

    public static Optional<LocalHandler> getLocalHandlerAnnotation(Class<?> target, Executable method) {
        return localHandlerCache.apply(target, method);
    }

    public static boolean isLocalHandler(Class<?> target, Executable method) {
        return ClientUtils.getLocalHandlerAnnotation(target, method).map(LocalHandler::value).orElse(false);
    }

    public static boolean isLocalHandler(HandlerInvoker invoker) {
        return invoker.getMethod() != null && ClientUtils.isLocalHandler(invoker.getTargetClass(), invoker.getMethod());
    }

    public static boolean isTrackingHandler(Class<?> target, Executable method) {
        return ClientUtils.getLocalHandlerAnnotation(target, method).map(l -> !l.value() || l.allowExternalMessages()).orElse(true);
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier, Duration lifespan) {
        return new MemoizingSupplier(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier, Duration lifespan) {
        return new MemoizingFunction(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier, Duration lifespan) {
        return new MemoizingBiFunction(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static SearchParameters getSearchParameters(Class<?> type) {
        return searchParametersCache.apply(type);
    }

    public static <T extends Temporal> T truncate(T timestamp, TemporalUnit unit) {
        Comparable<ChronoLocalDateTime<?>> r;
        TemporalUnit truncateUnit;
        T result;
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case YEARS: {
                    v0 = timestamp.with(TemporalAdjusters.firstDayOfYear());
                    break;
                }
                case MONTHS: {
                    v0 = timestamp.with(TemporalAdjusters.firstDayOfMonth());
                    break;
                }
                default: {
                    v0 = timestamp;
                    break;
                }
            }
        } else {
            v0 = result = timestamp;
        }
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case YEARS: 
                case MONTHS: {
                    v1 = ChronoUnit.DAYS;
                    break;
                }
                default: {
                    v1 = chronoUnit;
                    break;
                }
            }
        } else {
            v1 = truncateUnit = unit;
        }
        if (result instanceof LocalDate) {
            return result;
        }
        if (result instanceof LocalDateTime) {
            r = (LocalDateTime)result;
            return (T)((LocalDateTime)r).truncatedTo(truncateUnit);
        }
        if (result instanceof ZonedDateTime) {
            r = (ZonedDateTime)result;
            return (T)((ZonedDateTime)r).truncatedTo(truncateUnit);
        }
        if (result instanceof OffsetDateTime) {
            r = (OffsetDateTime)result;
            return (T)((OffsetDateTime)r).truncatedTo(truncateUnit);
        }
        if (result instanceof Instant) {
            r = (Instant)result;
            return (T)((Instant)r).truncatedTo(truncateUnit);
        }
        throw new UnsupportedOperationException("Unsupported temporal type: " + String.valueOf(result.getClass()));
    }
}

