/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.LoggerFactory;

public interface HasMessage
extends HasMetadata {
    public static final BiFunction<Class<?>, String, AtomicBoolean> warnedAboutMissingProperty = ClientUtils.memoize((type, property) -> new AtomicBoolean());

    public Message toMessage();

    default public <R> R getPayload() {
        return this.toMessage().getPayload();
    }

    default public <R> R getPayloadAs(Class<R> type) {
        return (R)JsonUtils.convertValue(this.getPayload(), type);
    }

    default public Class<?> getPayloadClass() {
        Object payload = this.getPayload();
        return payload == null ? Void.class : payload.getClass();
    }

    default public String getMessageId() {
        return this.toMessage().getMessageId();
    }

    default public Instant getTimestamp() {
        return this.toMessage().getTimestamp();
    }

    default public Optional<String> computeRoutingKey() {
        Message m = this.toMessage();
        String routingValue = null;
        Class<?> payloadType = m.getPayloadClass();
        RoutingKey typeAnnotation = Optional.ofNullable(payloadType.getAnnotation(RoutingKey.class)).filter(a -> !a.value().isBlank()).orElse(null);
        if (typeAnnotation != null) {
            return this.getRoutingKey(typeAnnotation.value());
        }
        if (m.getPayload() != null) {
            routingValue = ReflectionUtils.getAnnotatedPropertyValue(m.getPayload(), RoutingKey.class).map(Object::toString).orElse(null);
        }
        if (routingValue == null && m instanceof Schedule) {
            routingValue = ((Schedule)m).getScheduleId();
        }
        return Optional.ofNullable(routingValue);
    }

    default public Optional<String> getRoutingKey(String propertyName) {
        String result = this.getMetadata().get((Object)propertyName);
        if (result == null) {
            result = ReflectionUtils.readProperty((String)propertyName, this.getPayload()).map(Object::toString).orElse(null);
        }
        if (result == null && warnedAboutMissingProperty.apply(this.getPayloadClass(), propertyName).compareAndSet(false, true)) {
            LoggerFactory.getLogger(HasMessage.class).warn("Did not find property (field, method, or metadata key) '{}' for routing key on message {} (id {})", new Object[]{propertyName, this.getPayloadClass(), this.toMessage().getMessageId()});
        }
        return Optional.ofNullable(result);
    }
}

