/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public class AnnotatedCaster<T> {
    private final Method method;
    private final CastParameters parameters;
    private final Function<SerializedObject<T, ?>, Stream<SerializedObject<T, ?>>> castFunction;

    public AnnotatedCaster(Method method, CastParameters castParameters, Function<SerializedObject<T, ?>, Stream<SerializedObject<T, ?>>> castFunction) {
        this.method = method;
        this.parameters = castParameters;
        this.castFunction = castFunction;
    }

    public <S extends SerializedObject<T, S>> Stream<S> cast(S input) {
        return this.parameters.type().equals(input.data().getType()) && this.parameters.revision() == input.data().getRevision() ? this.castFunction.apply(input) : Stream.of(input);
    }

    public String toString() {
        return this.method.toString();
    }

    @Generated
    public CastParameters getParameters() {
        return this.parameters;
    }
}

