/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import io.fluxcapacitor.javaclient.configuration.ApplicationProperties;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={Condition.class})
public @interface ConditionalOnMissingProperty {
    public String value();

    @Order(value=-2147483648)
    public static class Condition
    implements org.springframework.context.annotation.Condition {
        public boolean matches(@NotNull ConditionContext context, AnnotatedTypeMetadata metadata) {
            String value = ApplicationProperties.getProperty(metadata.getAllAnnotationAttributes(ConditionalOnMissingProperty.class.getName()).getFirst((Object)"value").toString());
            return value == null || value.isEmpty();
        }
    }
}

