/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import io.fluxcapacitor.javaclient.configuration.spring.FluxPrototype;
import io.fluxcapacitor.javaclient.tracking.handling.Stateful;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class StatefulPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatefulPostProcessor.class);

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked non-null but is null");
        }
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            log.warn("Cannot register Spring beans dynamically! @Stateful annotations will be ignored.");
            return;
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        Arrays.stream(beanFactory.getBeanNamesForAnnotation(Stateful.class)).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getType(arg_0)).filter(Objects::nonNull).map(FluxPrototype::new).forEach(prototype -> registry.registerBeanDefinition(prototype.getType().getName() + "$$Stateful", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FluxPrototype.class, () -> prototype).getBeanDefinition()));
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
    }
}

